/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;

@OpMetadata(opType="SparseCrossHashed", inputsClass=Inputs.class)
public final class SparseCrossHashed
extends RawOp {
    public static final String OP_NAME = "SparseCrossHashed";
    private Output<TInt64> outputIndices;
    private Output<TInt64> outputValues;
    private Output<TInt64> outputShape;

    public SparseCrossHashed(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.outputShape = operation.output(outputIdx++);
    }

    public static SparseCrossHashed create(Scope scope, Iterable<Operand<TInt64>> indices, Iterable<Operand<?>> values, Iterable<Operand<TInt64>> shapes, Iterable<Operand<?>> denseInputs, Operand<TInt64> numBuckets, Operand<TBool> strongHash, Operand<TInt64> salt) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(indices));
        opBuilder.addInputList(Operands.asOutputs(values));
        opBuilder.addInputList(Operands.asOutputs(shapes));
        opBuilder.addInputList(Operands.asOutputs(denseInputs));
        opBuilder.addInput(numBuckets.asOutput());
        opBuilder.addInput(strongHash.asOutput());
        opBuilder.addInput(salt.asOutput());
        return new SparseCrossHashed(opBuilder.build());
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<TInt64> outputValues() {
        return this.outputValues;
    }

    public Output<TInt64> outputShape() {
        return this.outputShape;
    }

    @OpInputsMetadata(outputsClass=SparseCrossHashed.class)
    public static class Inputs
    extends RawOpInputs<SparseCrossHashed> {
        public final Iterable<Operand<TInt64>> indices;
        public final Iterable<Operand<?>> values;
        public final Iterable<Operand<TInt64>> shapes;
        public final Iterable<Operand<?>> denseInputs;
        public final Operand<TInt64> numBuckets;
        public final Operand<TBool> strongHash;
        public final Operand<TInt64> salt;
        public final DataType[] sparseTypes;
        public final DataType[] denseTypes;

        public Inputs(GraphOperation op) {
            super(new SparseCrossHashed(op), op, Arrays.asList("sparse_types", "dense_types"));
            int inputIndex = 0;
            int indicesLength = op.inputListLength("indices");
            this.indices = Arrays.asList((Operand[])op.inputList(inputIndex, indicesLength));
            int valuesLength = op.inputListLength("values");
            this.values = Arrays.asList((Operand[])op.inputList(inputIndex += indicesLength, valuesLength));
            int shapesLength = op.inputListLength("shapes");
            this.shapes = Arrays.asList((Operand[])op.inputList(inputIndex += valuesLength, shapesLength));
            int denseInputsLength = op.inputListLength("dense_inputs");
            this.denseInputs = Arrays.asList((Operand[])op.inputList(inputIndex += shapesLength, denseInputsLength));
            inputIndex += denseInputsLength;
            this.numBuckets = op.input(inputIndex++);
            this.strongHash = op.input(inputIndex++);
            this.salt = op.input(inputIndex++);
            this.sparseTypes = op.attributes().getAttrTypeList("sparse_types");
            this.denseTypes = op.attributes().getAttrTypeList("dense_types");
        }
    }
}

