/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.risc;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RiscConv", inputsClass=Inputs.class)
public final class RiscConv<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RiscConv";
    private Output<T> output;

    public RiscConv(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> RiscConv<T> create(Scope scope, Operand<T> input, Operand<T> filter, List<Long> strides, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(filter.asOutput());
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dataFormat != null) {
                    opBuilder.setAttr("data_format", opts.dataFormat);
                }
                if (opts.dilations == null) continue;
                long[] dilationsArray = new long[opts.dilations.size()];
                for (int i = 0; i < dilationsArray.length; ++i) {
                    dilationsArray[i] = opts.dilations.get(i);
                }
                opBuilder.setAttr("dilations", dilationsArray);
            }
        }
        return new RiscConv<T>(opBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public static Options dilations(Long ... dilations) {
        return new Options().dilations(dilations);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RiscConv.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<RiscConv<T>> {
        public final Operand<T> input;
        public final Operand<T> filter;
        public final DataType T;
        public final long[] strides;
        public final String dataFormat;
        public final long[] dilations;

        public Inputs(GraphOperation op) {
            super(new RiscConv(op), op, Arrays.asList("T", "strides", "data_format", "dilations"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.filter = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.strides = op.attributes().getAttrIntList("strides");
            this.dataFormat = op.attributes().getAttrString("data_format");
            this.dilations = op.attributes().getAttrIntList("dilations");
        }
    }

    public static class Options {
        private String dataFormat;
        private List<Long> dilations;

        private Options() {
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        public Options dilations(Long ... dilations) {
            this.dilations = Arrays.asList(dilations);
            return this;
        }
    }
}

