/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.random;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RandomShuffle", inputsClass=Inputs.class)
public final class RandomShuffle<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RandomShuffle";
    private Output<T> output;

    public RandomShuffle(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> RandomShuffle<T> create(Scope scope, Operand<T> value, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(value.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new RandomShuffle<T>(opBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RandomShuffle.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<RandomShuffle<T>> {
        public final Operand<T> value;
        public final long seed;
        public final long seed2;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new RandomShuffle(op), op, Arrays.asList("seed", "seed2", "T"));
            int inputIndex = 0;
            this.value = op.input(inputIndex++);
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        private Options() {
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }
    }
}

