/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RaggedTensorToVariantGradient", inputsClass=Inputs.class)
public final class RaggedTensorToVariantGradient<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "RaggedTensorToVariantGradient";
    private Output<U> denseValuesGrad;

    public RaggedTensorToVariantGradient(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.denseValuesGrad = operation.output(outputIdx++);
    }

    public static <U extends TType> RaggedTensorToVariantGradient<U> create(Scope scope, Operand<? extends TType> encodedRaggedGrad, Operand<? extends TNumber> rowSplits, Operand<TInt32> denseValuesShape, Class<U> Tvalues) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(encodedRaggedGrad.asOutput());
        opBuilder.addInput(rowSplits.asOutput());
        opBuilder.addInput(denseValuesShape.asOutput());
        opBuilder.setAttr("Tvalues", Operands.toDataType(Tvalues));
        return new RaggedTensorToVariantGradient<U>(opBuilder.build());
    }

    public Output<U> denseValuesGrad() {
        return this.denseValuesGrad;
    }

    @Override
    public Output<U> asOutput() {
        return this.denseValuesGrad;
    }

    @OpInputsMetadata(outputsClass=RaggedTensorToVariantGradient.class)
    public static class Inputs
    extends RawOpInputs<RaggedTensorToVariantGradient<?>> {
        public final Operand<? extends TType> encodedRaggedGrad;
        public final Operand<? extends TNumber> rowSplits;
        public final Operand<TInt32> denseValuesShape;
        public final DataType Tvalues;
        public final DataType Tsplits;

        public Inputs(GraphOperation op) {
            super(new RaggedTensorToVariantGradient(op), op, Arrays.asList("Tvalues", "Tsplits"));
            int inputIndex = 0;
            this.encodedRaggedGrad = op.input(inputIndex++);
            this.rowSplits = op.input(inputIndex++);
            this.denseValuesShape = op.input(inputIndex++);
            this.Tvalues = op.attributes().getAttrType("Tvalues");
            this.Tsplits = op.attributes().getAttrType("Tsplits");
        }
    }
}

