/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="FractionalAvgPool", inputsClass=Inputs.class)
public final class FractionalAvgPool<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "FractionalAvgPool";
    private Output<T> output;
    private Output<TInt64> rowPoolingSequence;
    private Output<TInt64> colPoolingSequence;

    public FractionalAvgPool(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.rowPoolingSequence = operation.output(outputIdx++);
        this.colPoolingSequence = operation.output(outputIdx++);
    }

    public static <T extends TNumber> FractionalAvgPool<T> create(Scope scope, Operand<T> value, List<Float> poolingRatio, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(value.asOutput());
        float[] poolingRatioArray = new float[poolingRatio.size()];
        for (int i = 0; i < poolingRatioArray.length; ++i) {
            poolingRatioArray[i] = poolingRatio.get(i).floatValue();
        }
        opBuilder.setAttr("pooling_ratio", poolingRatioArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.pseudoRandom != null) {
                    opBuilder.setAttr("pseudo_random", opts.pseudoRandom);
                }
                if (opts.overlapping != null) {
                    opBuilder.setAttr("overlapping", opts.overlapping);
                }
                if (opts.deterministic != null) {
                    opBuilder.setAttr("deterministic", opts.deterministic);
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new FractionalAvgPool<T>(opBuilder.build());
    }

    public static Options pseudoRandom(Boolean pseudoRandom) {
        return new Options().pseudoRandom(pseudoRandom);
    }

    public static Options overlapping(Boolean overlapping) {
        return new Options().overlapping(overlapping);
    }

    public static Options deterministic(Boolean deterministic) {
        return new Options().deterministic(deterministic);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<TInt64> rowPoolingSequence() {
        return this.rowPoolingSequence;
    }

    public Output<TInt64> colPoolingSequence() {
        return this.colPoolingSequence;
    }

    @OpInputsMetadata(outputsClass=FractionalAvgPool.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<FractionalAvgPool<T>> {
        public final Operand<T> value;
        public final float[] poolingRatio;
        public final boolean pseudoRandom;
        public final boolean overlapping;
        public final boolean deterministic;
        public final long seed;
        public final long seed2;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new FractionalAvgPool(op), op, Arrays.asList("pooling_ratio", "pseudo_random", "overlapping", "deterministic", "seed", "seed2", "T"));
            int inputIndex = 0;
            this.value = op.input(inputIndex++);
            this.poolingRatio = op.attributes().getAttrFloatList("pooling_ratio");
            this.pseudoRandom = op.attributes().getAttrBool("pseudo_random");
            this.overlapping = op.attributes().getAttrBool("overlapping");
            this.deterministic = op.attributes().getAttrBool("deterministic");
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean pseudoRandom;
        private Boolean overlapping;
        private Boolean deterministic;
        private Long seed;
        private Long seed2;

        private Options() {
        }

        public Options pseudoRandom(Boolean pseudoRandom) {
            this.pseudoRandom = pseudoRandom;
            return this;
        }

        public Options overlapping(Boolean overlapping) {
            this.overlapping = overlapping;
            return this;
        }

        public Options deterministic(Boolean deterministic) {
            this.deterministic = deterministic;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }
    }
}

