/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="CudnnRNNParamsToCanonicalV2", inputsClass=Inputs.class)
public final class CudnnRNNParamsToCanonical<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "CudnnRNNParamsToCanonicalV2";
    private List<Output<T>> weights;
    private List<Output<T>> biases;

    public CudnnRNNParamsToCanonical(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int weightsLength = operation.outputListLength("weights");
        this.weights = Arrays.asList(operation.outputList(outputIdx, weightsLength));
        int biasesLength = operation.outputListLength("biases");
        this.biases = Arrays.asList(operation.outputList(outputIdx += weightsLength, biasesLength));
        outputIdx += biasesLength;
    }

    public static <T extends TNumber> CudnnRNNParamsToCanonical<T> create(Scope scope, Operand<TInt32> numLayers, Operand<TInt32> numUnits, Operand<TInt32> inputSize, Operand<T> params, Long numParamsWeights, Long numParamsBiases, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "CudnnRNNParamsToCanonical");
        opBuilder.addInput(numLayers.asOutput());
        opBuilder.addInput(numUnits.asOutput());
        opBuilder.addInput(inputSize.asOutput());
        opBuilder.addInput(params.asOutput());
        opBuilder.setAttr("num_params_weights", numParamsWeights);
        opBuilder.setAttr("num_params_biases", numParamsBiases);
        if (options != null) {
            for (Options opts : options) {
                if (opts.rnnMode != null) {
                    opBuilder.setAttr("rnn_mode", opts.rnnMode);
                }
                if (opts.inputMode != null) {
                    opBuilder.setAttr("input_mode", opts.inputMode);
                }
                if (opts.direction != null) {
                    opBuilder.setAttr("direction", opts.direction);
                }
                if (opts.dropout != null) {
                    opBuilder.setAttr("dropout", opts.dropout.floatValue());
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 != null) {
                    opBuilder.setAttr("seed2", opts.seed2);
                }
                if (opts.numProj == null) continue;
                opBuilder.setAttr("num_proj", opts.numProj);
            }
        }
        return new CudnnRNNParamsToCanonical<T>(opBuilder.build());
    }

    public static Options rnnMode(String rnnMode) {
        return new Options().rnnMode(rnnMode);
    }

    public static Options inputMode(String inputMode) {
        return new Options().inputMode(inputMode);
    }

    public static Options direction(String direction) {
        return new Options().direction(direction);
    }

    public static Options dropout(Float dropout) {
        return new Options().dropout(dropout);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options numProj(Long numProj) {
        return new Options().numProj(numProj);
    }

    public List<Output<T>> weights() {
        return this.weights;
    }

    public List<Output<T>> biases() {
        return this.biases;
    }

    @OpInputsMetadata(outputsClass=CudnnRNNParamsToCanonical.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<CudnnRNNParamsToCanonical<T>> {
        public final Operand<TInt32> numLayers;
        public final Operand<TInt32> numUnits;
        public final Operand<TInt32> inputSize;
        public final Operand<T> params;
        public final DataType T;
        public final String rnnMode;
        public final String inputMode;
        public final String direction;
        public final float dropout;
        public final long seed;
        public final long seed2;
        public final long numProj;

        public Inputs(GraphOperation op) {
            super(new CudnnRNNParamsToCanonical(op), op, Arrays.asList("T", "rnn_mode", "input_mode", "direction", "dropout", "seed", "seed2", "num_proj"));
            int inputIndex = 0;
            this.numLayers = op.input(inputIndex++);
            this.numUnits = op.input(inputIndex++);
            this.inputSize = op.input(inputIndex++);
            this.params = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.rnnMode = op.attributes().getAttrString("rnn_mode");
            this.inputMode = op.attributes().getAttrString("input_mode");
            this.direction = op.attributes().getAttrString("direction");
            this.dropout = op.attributes().getAttrFloat("dropout");
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
            this.numProj = op.attributes().getAttrInt("num_proj");
        }
    }

    public static class Options {
        private String rnnMode;
        private String inputMode;
        private String direction;
        private Float dropout;
        private Long seed;
        private Long seed2;
        private Long numProj;

        private Options() {
        }

        public Options rnnMode(String rnnMode) {
            this.rnnMode = rnnMode;
            return this;
        }

        public Options inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        public Options direction(String direction) {
            this.direction = direction;
            return this;
        }

        public Options dropout(Float dropout) {
            this.dropout = dropout;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options numProj(Long numProj) {
            this.numProj = numProj;
            return this;
        }
    }
}

