/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CudnnRNNBackpropV3", inputsClass=Inputs.class)
public final class CudnnRNNBackprop<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "CudnnRNNBackpropV3";
    private Output<T> inputBackprop;
    private Output<T> inputHBackprop;
    private Output<T> inputCBackprop;
    private Output<T> paramsBackprop;

    public CudnnRNNBackprop(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.inputBackprop = operation.output(outputIdx++);
        this.inputHBackprop = operation.output(outputIdx++);
        this.inputCBackprop = operation.output(outputIdx++);
        this.paramsBackprop = operation.output(outputIdx++);
    }

    public static <T extends TNumber> CudnnRNNBackprop<T> create(Scope scope, Operand<T> input, Operand<T> inputH, Operand<T> inputC, Operand<T> params, Operand<TInt32> sequenceLengths, Operand<T> output, Operand<T> outputH, Operand<T> outputC, Operand<T> outputBackprop, Operand<T> outputHBackprop, Operand<T> outputCBackprop, Operand<T> reserveSpace, Operand<? extends TType> hostReserved, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "CudnnRNNBackprop");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(inputH.asOutput());
        opBuilder.addInput(inputC.asOutput());
        opBuilder.addInput(params.asOutput());
        opBuilder.addInput(sequenceLengths.asOutput());
        opBuilder.addInput(output.asOutput());
        opBuilder.addInput(outputH.asOutput());
        opBuilder.addInput(outputC.asOutput());
        opBuilder.addInput(outputBackprop.asOutput());
        opBuilder.addInput(outputHBackprop.asOutput());
        opBuilder.addInput(outputCBackprop.asOutput());
        opBuilder.addInput(reserveSpace.asOutput());
        opBuilder.addInput(hostReserved.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.rnnMode != null) {
                    opBuilder.setAttr("rnn_mode", opts.rnnMode);
                }
                if (opts.inputMode != null) {
                    opBuilder.setAttr("input_mode", opts.inputMode);
                }
                if (opts.direction != null) {
                    opBuilder.setAttr("direction", opts.direction);
                }
                if (opts.dropout != null) {
                    opBuilder.setAttr("dropout", opts.dropout.floatValue());
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 != null) {
                    opBuilder.setAttr("seed2", opts.seed2);
                }
                if (opts.numProj != null) {
                    opBuilder.setAttr("num_proj", opts.numProj);
                }
                if (opts.timeMajor == null) continue;
                opBuilder.setAttr("time_major", opts.timeMajor);
            }
        }
        return new CudnnRNNBackprop<T>(opBuilder.build());
    }

    public static Options rnnMode(String rnnMode) {
        return new Options().rnnMode(rnnMode);
    }

    public static Options inputMode(String inputMode) {
        return new Options().inputMode(inputMode);
    }

    public static Options direction(String direction) {
        return new Options().direction(direction);
    }

    public static Options dropout(Float dropout) {
        return new Options().dropout(dropout);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options numProj(Long numProj) {
        return new Options().numProj(numProj);
    }

    public static Options timeMajor(Boolean timeMajor) {
        return new Options().timeMajor(timeMajor);
    }

    public Output<T> inputBackprop() {
        return this.inputBackprop;
    }

    public Output<T> inputHBackprop() {
        return this.inputHBackprop;
    }

    public Output<T> inputCBackprop() {
        return this.inputCBackprop;
    }

    public Output<T> paramsBackprop() {
        return this.paramsBackprop;
    }

    @OpInputsMetadata(outputsClass=CudnnRNNBackprop.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<CudnnRNNBackprop<T>> {
        public final Operand<T> input;
        public final Operand<T> inputH;
        public final Operand<T> inputC;
        public final Operand<T> params;
        public final Operand<TInt32> sequenceLengths;
        public final Operand<T> output;
        public final Operand<T> outputH;
        public final Operand<T> outputC;
        public final Operand<T> outputBackprop;
        public final Operand<T> outputHBackprop;
        public final Operand<T> outputCBackprop;
        public final Operand<T> reserveSpace;
        public final Operand<? extends TType> hostReserved;
        public final DataType T;
        public final String rnnMode;
        public final String inputMode;
        public final String direction;
        public final float dropout;
        public final long seed;
        public final long seed2;
        public final long numProj;
        public final boolean timeMajor;

        public Inputs(GraphOperation op) {
            super(new CudnnRNNBackprop(op), op, Arrays.asList("T", "rnn_mode", "input_mode", "direction", "dropout", "seed", "seed2", "num_proj", "time_major"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.inputH = op.input(inputIndex++);
            this.inputC = op.input(inputIndex++);
            this.params = op.input(inputIndex++);
            this.sequenceLengths = op.input(inputIndex++);
            this.output = op.input(inputIndex++);
            this.outputH = op.input(inputIndex++);
            this.outputC = op.input(inputIndex++);
            this.outputBackprop = op.input(inputIndex++);
            this.outputHBackprop = op.input(inputIndex++);
            this.outputCBackprop = op.input(inputIndex++);
            this.reserveSpace = op.input(inputIndex++);
            this.hostReserved = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.rnnMode = op.attributes().getAttrString("rnn_mode");
            this.inputMode = op.attributes().getAttrString("input_mode");
            this.direction = op.attributes().getAttrString("direction");
            this.dropout = op.attributes().getAttrFloat("dropout");
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
            this.numProj = op.attributes().getAttrInt("num_proj");
            this.timeMajor = op.attributes().getAttrBool("time_major");
        }
    }

    public static class Options {
        private String rnnMode;
        private String inputMode;
        private String direction;
        private Float dropout;
        private Long seed;
        private Long seed2;
        private Long numProj;
        private Boolean timeMajor;

        private Options() {
        }

        public Options rnnMode(String rnnMode) {
            this.rnnMode = rnnMode;
            return this;
        }

        public Options inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        public Options direction(String direction) {
            this.direction = direction;
            return this;
        }

        public Options dropout(Float dropout) {
            this.dropout = dropout;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options numProj(Long numProj) {
            this.numProj = numProj;
            return this;
        }

        public Options timeMajor(Boolean timeMajor) {
            this.timeMajor = timeMajor;
            return this;
        }
    }
}

