/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseMatrixMatMul", inputsClass=Inputs.class)
public final class SparseMatrixMatMul<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "SparseMatrixMatMul";
    private Output<T> output;

    public SparseMatrixMatMul(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseMatrixMatMul<T> create(Scope scope, Operand<? extends TType> a, Operand<T> b, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.transposeA != null) {
                    opBuilder.setAttr("transpose_a", opts.transposeA);
                }
                if (opts.transposeB != null) {
                    opBuilder.setAttr("transpose_b", opts.transposeB);
                }
                if (opts.adjointA != null) {
                    opBuilder.setAttr("adjoint_a", opts.adjointA);
                }
                if (opts.adjointB != null) {
                    opBuilder.setAttr("adjoint_b", opts.adjointB);
                }
                if (opts.transposeOutput != null) {
                    opBuilder.setAttr("transpose_output", opts.transposeOutput);
                }
                if (opts.conjugateOutput == null) continue;
                opBuilder.setAttr("conjugate_output", opts.conjugateOutput);
            }
        }
        return new SparseMatrixMatMul<T>(opBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public static Options adjointA(Boolean adjointA) {
        return new Options().adjointA(adjointA);
    }

    public static Options adjointB(Boolean adjointB) {
        return new Options().adjointB(adjointB);
    }

    public static Options transposeOutput(Boolean transposeOutput) {
        return new Options().transposeOutput(transposeOutput);
    }

    public static Options conjugateOutput(Boolean conjugateOutput) {
        return new Options().conjugateOutput(conjugateOutput);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SparseMatrixMatMul.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SparseMatrixMatMul<T>> {
        public final Operand<? extends TType> a;
        public final Operand<T> b;
        public final DataType T;
        public final boolean transposeA;
        public final boolean transposeB;
        public final boolean adjointA;
        public final boolean adjointB;
        public final boolean transposeOutput;
        public final boolean conjugateOutput;

        public Inputs(GraphOperation op) {
            super(new SparseMatrixMatMul(op), op, Arrays.asList("T", "transpose_a", "transpose_b", "adjoint_a", "adjoint_b", "transpose_output", "conjugate_output"));
            int inputIndex = 0;
            this.a = op.input(inputIndex++);
            this.b = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.transposeA = op.attributes().getAttrBool("transpose_a");
            this.transposeB = op.attributes().getAttrBool("transpose_b");
            this.adjointA = op.attributes().getAttrBool("adjoint_a");
            this.adjointB = op.attributes().getAttrBool("adjoint_b");
            this.transposeOutput = op.attributes().getAttrBool("transpose_output");
            this.conjugateOutput = op.attributes().getAttrBool("conjugate_output");
        }
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;
        private Boolean adjointA;
        private Boolean adjointB;
        private Boolean transposeOutput;
        private Boolean conjugateOutput;

        private Options() {
        }

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        public Options adjointA(Boolean adjointA) {
            this.adjointA = adjointA;
            return this;
        }

        public Options adjointB(Boolean adjointB) {
            this.adjointB = adjointB;
            return this;
        }

        public Options transposeOutput(Boolean transposeOutput) {
            this.transposeOutput = transposeOutput;
            return this;
        }

        public Options conjugateOutput(Boolean conjugateOutput) {
            this.conjugateOutput = conjugateOutput;
            return this;
        }
    }
}

