/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="MatrixDiagV3", inputsClass=Inputs.class)
public final class MatrixDiagV3<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "MatrixDiagV3";
    private Output<T> output;

    public MatrixDiagV3(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> MatrixDiagV3<T> create(Scope scope, Operand<T> diagonal, Operand<TInt32> k, Operand<TInt32> numRows, Operand<TInt32> numCols, Operand<T> paddingValue, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(diagonal.asOutput());
        opBuilder.addInput(k.asOutput());
        opBuilder.addInput(numRows.asOutput());
        opBuilder.addInput(numCols.asOutput());
        opBuilder.addInput(paddingValue.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.align == null) continue;
                opBuilder.setAttr("align", opts.align);
            }
        }
        return new MatrixDiagV3<T>(opBuilder.build());
    }

    public static Options align(String align) {
        return new Options().align(align);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=MatrixDiagV3.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<MatrixDiagV3<T>> {
        public final Operand<T> diagonal;
        public final Operand<TInt32> k;
        public final Operand<TInt32> numRows;
        public final Operand<TInt32> numCols;
        public final Operand<T> paddingValue;
        public final DataType T;
        public final String align;

        public Inputs(GraphOperation op) {
            super(new MatrixDiagV3(op), op, Arrays.asList("T", "align"));
            int inputIndex = 0;
            this.diagonal = op.input(inputIndex++);
            this.k = op.input(inputIndex++);
            this.numRows = op.input(inputIndex++);
            this.numCols = op.input(inputIndex++);
            this.paddingValue = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.align = op.attributes().getAttrString("align");
        }
    }

    public static class Options {
        private String align;

        private Options() {
        }

        public Options align(String align) {
            this.align = align;
            return this;
        }
    }
}

