/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="QueueEnqueueManyV2", inputsClass=Inputs.class)
public final class QueueEnqueueMany
extends RawOp {
    public static final String OP_NAME = "QueueEnqueueManyV2";

    public QueueEnqueueMany(Operation operation) {
        super(operation, OP_NAME);
    }

    public static QueueEnqueueMany create(Scope scope, Operand<? extends TType> handle, Iterable<Operand<?>> components, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "QueueEnqueueMany");
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInputList(Operands.asOutputs(components));
        if (options != null) {
            for (Options opts : options) {
                if (opts.timeoutMs == null) continue;
                opBuilder.setAttr("timeout_ms", opts.timeoutMs);
            }
        }
        return new QueueEnqueueMany(opBuilder.build());
    }

    public static Options timeoutMs(Long timeoutMs) {
        return new Options().timeoutMs(timeoutMs);
    }

    @OpInputsMetadata(outputsClass=QueueEnqueueMany.class)
    public static class Inputs
    extends RawOpInputs<QueueEnqueueMany> {
        public final Operand<? extends TType> handle;
        public final Iterable<Operand<?>> components;
        public final DataType[] Tcomponents;
        public final long timeoutMs;

        public Inputs(GraphOperation op) {
            super(new QueueEnqueueMany(op), op, Arrays.asList("Tcomponents", "timeout_ms"));
            int inputIndex = 0;
            this.handle = op.input(inputIndex++);
            int componentsLength = op.inputListLength("components");
            this.components = Arrays.asList((Operand[])op.inputList(inputIndex, componentsLength));
            inputIndex += componentsLength;
            this.Tcomponents = op.attributes().getAttrTypeList("Tcomponents");
            this.timeoutMs = op.attributes().getAttrInt("timeout_ms");
        }
    }

    public static class Options {
        private Long timeoutMs;

        private Options() {
        }

        public Options timeoutMs(Long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }
    }
}

