/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ParseSequenceExampleV2", inputsClass=Inputs.class)
public final class ParseSequenceExample
extends RawOp {
    public static final String OP_NAME = "ParseSequenceExampleV2";
    private List<Output<TInt64>> contextSparseIndices;
    private List<Output<?>> contextSparseValues;
    private List<Output<TInt64>> contextSparseShapes;
    private List<Output<?>> contextDenseValues;
    private List<Output<?>> contextRaggedValues;
    private List<Output<?>> contextRaggedRowSplits;
    private List<Output<TInt64>> featureListSparseIndices;
    private List<Output<?>> featureListSparseValues;
    private List<Output<TInt64>> featureListSparseShapes;
    private List<Output<?>> featureListDenseValues;
    private List<Output<TInt64>> featureListDenseLengths;
    private List<Output<?>> featureListRaggedValues;
    private List<Output<?>> featureListRaggedOuterSplits;
    private List<Output<?>> featureListRaggedInnerSplits;

    public ParseSequenceExample(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int contextSparseIndicesLength = operation.outputListLength("context_sparse_indices");
        this.contextSparseIndices = Arrays.asList(operation.outputList(outputIdx, contextSparseIndicesLength));
        int contextSparseValuesLength = operation.outputListLength("context_sparse_values");
        this.contextSparseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseIndicesLength, contextSparseValuesLength));
        int contextSparseShapesLength = operation.outputListLength("context_sparse_shapes");
        this.contextSparseShapes = Arrays.asList(operation.outputList(outputIdx += contextSparseValuesLength, contextSparseShapesLength));
        int contextDenseValuesLength = operation.outputListLength("context_dense_values");
        this.contextDenseValues = Arrays.asList(operation.outputList(outputIdx += contextSparseShapesLength, contextDenseValuesLength));
        int contextRaggedValuesLength = operation.outputListLength("context_ragged_values");
        this.contextRaggedValues = Arrays.asList(operation.outputList(outputIdx += contextDenseValuesLength, contextRaggedValuesLength));
        int contextRaggedRowSplitsLength = operation.outputListLength("context_ragged_row_splits");
        this.contextRaggedRowSplits = Arrays.asList(operation.outputList(outputIdx += contextRaggedValuesLength, contextRaggedRowSplitsLength));
        int featureListSparseIndicesLength = operation.outputListLength("feature_list_sparse_indices");
        this.featureListSparseIndices = Arrays.asList(operation.outputList(outputIdx += contextRaggedRowSplitsLength, featureListSparseIndicesLength));
        int featureListSparseValuesLength = operation.outputListLength("feature_list_sparse_values");
        this.featureListSparseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseIndicesLength, featureListSparseValuesLength));
        int featureListSparseShapesLength = operation.outputListLength("feature_list_sparse_shapes");
        this.featureListSparseShapes = Arrays.asList(operation.outputList(outputIdx += featureListSparseValuesLength, featureListSparseShapesLength));
        int featureListDenseValuesLength = operation.outputListLength("feature_list_dense_values");
        this.featureListDenseValues = Arrays.asList(operation.outputList(outputIdx += featureListSparseShapesLength, featureListDenseValuesLength));
        int featureListDenseLengthsLength = operation.outputListLength("feature_list_dense_lengths");
        this.featureListDenseLengths = Arrays.asList(operation.outputList(outputIdx += featureListDenseValuesLength, featureListDenseLengthsLength));
        int featureListRaggedValuesLength = operation.outputListLength("feature_list_ragged_values");
        this.featureListRaggedValues = Arrays.asList(operation.outputList(outputIdx += featureListDenseLengthsLength, featureListRaggedValuesLength));
        int featureListRaggedOuterSplitsLength = operation.outputListLength("feature_list_ragged_outer_splits");
        this.featureListRaggedOuterSplits = Arrays.asList(operation.outputList(outputIdx += featureListRaggedValuesLength, featureListRaggedOuterSplitsLength));
        int featureListRaggedInnerSplitsLength = operation.outputListLength("feature_list_ragged_inner_splits");
        this.featureListRaggedInnerSplits = Arrays.asList(operation.outputList(outputIdx += featureListRaggedOuterSplitsLength, featureListRaggedInnerSplitsLength));
        outputIdx += featureListRaggedInnerSplitsLength;
    }

    public static ParseSequenceExample create(Scope scope, Operand<TString> serialized, Operand<TString> debugName, Operand<TString> contextSparseKeys, Operand<TString> contextDenseKeys, Operand<TString> contextRaggedKeys, Operand<TString> featureListSparseKeys, Operand<TString> featureListDenseKeys, Operand<TString> featureListRaggedKeys, Operand<TBool> featureListDenseMissingAssumedEmpty, Iterable<Operand<?>> contextDenseDefaults, List<Class<? extends TType>> contextSparseTypes, List<Class<? extends TType>> contextRaggedValueTypes, List<Class<? extends TNumber>> contextRaggedSplitTypes, List<Class<? extends TType>> featureListDenseTypes, List<Class<? extends TType>> featureListSparseTypes, List<Class<? extends TType>> featureListRaggedValueTypes, List<Class<? extends TNumber>> featureListRaggedSplitTypes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "ParseSequenceExample");
        opBuilder.addInput(serialized.asOutput());
        opBuilder.addInput(debugName.asOutput());
        opBuilder.addInput(contextSparseKeys.asOutput());
        opBuilder.addInput(contextDenseKeys.asOutput());
        opBuilder.addInput(contextRaggedKeys.asOutput());
        opBuilder.addInput(featureListSparseKeys.asOutput());
        opBuilder.addInput(featureListDenseKeys.asOutput());
        opBuilder.addInput(featureListRaggedKeys.asOutput());
        opBuilder.addInput(featureListDenseMissingAssumedEmpty.asOutput());
        opBuilder.addInputList(Operands.asOutputs(contextDenseDefaults));
        opBuilder.setAttr("context_sparse_types", Operands.toDataTypes(contextSparseTypes));
        opBuilder.setAttr("context_ragged_value_types", Operands.toDataTypes(contextRaggedValueTypes));
        opBuilder.setAttr("context_ragged_split_types", Operands.toDataTypes(contextRaggedSplitTypes));
        opBuilder.setAttr("feature_list_dense_types", Operands.toDataTypes(featureListDenseTypes));
        opBuilder.setAttr("feature_list_sparse_types", Operands.toDataTypes(featureListSparseTypes));
        opBuilder.setAttr("feature_list_ragged_value_types", Operands.toDataTypes(featureListRaggedValueTypes));
        opBuilder.setAttr("feature_list_ragged_split_types", Operands.toDataTypes(featureListRaggedSplitTypes));
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.NcontextSparse != null) {
                    opBuilder.setAttr("Ncontext_sparse", opts.NcontextSparse);
                }
                if (opts.contextDenseShapes != null) {
                    Shape[] contextDenseShapesArray = new Shape[opts.contextDenseShapes.size()];
                    for (i = 0; i < contextDenseShapesArray.length; ++i) {
                        contextDenseShapesArray[i] = opts.contextDenseShapes.get(i);
                    }
                    opBuilder.setAttr("context_dense_shapes", contextDenseShapesArray);
                }
                if (opts.NfeatureListSparse != null) {
                    opBuilder.setAttr("Nfeature_list_sparse", opts.NfeatureListSparse);
                }
                if (opts.NfeatureListDense != null) {
                    opBuilder.setAttr("Nfeature_list_dense", opts.NfeatureListDense);
                }
                if (opts.featureListDenseShapes == null) continue;
                Shape[] featureListDenseShapesArray = new Shape[opts.featureListDenseShapes.size()];
                for (i = 0; i < featureListDenseShapesArray.length; ++i) {
                    featureListDenseShapesArray[i] = opts.featureListDenseShapes.get(i);
                }
                opBuilder.setAttr("feature_list_dense_shapes", featureListDenseShapesArray);
            }
        }
        return new ParseSequenceExample(opBuilder.build());
    }

    public static Options NcontextSparse(Long NcontextSparse) {
        return new Options().NcontextSparse(NcontextSparse);
    }

    public static Options contextDenseShapes(List<Shape> contextDenseShapes) {
        return new Options().contextDenseShapes(contextDenseShapes);
    }

    public static Options contextDenseShapes(Shape ... contextDenseShapes) {
        return new Options().contextDenseShapes(contextDenseShapes);
    }

    public static Options NfeatureListSparse(Long NfeatureListSparse) {
        return new Options().NfeatureListSparse(NfeatureListSparse);
    }

    public static Options NfeatureListDense(Long NfeatureListDense) {
        return new Options().NfeatureListDense(NfeatureListDense);
    }

    public static Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
        return new Options().featureListDenseShapes(featureListDenseShapes);
    }

    public static Options featureListDenseShapes(Shape ... featureListDenseShapes) {
        return new Options().featureListDenseShapes(featureListDenseShapes);
    }

    public List<Output<TInt64>> contextSparseIndices() {
        return this.contextSparseIndices;
    }

    public List<Output<?>> contextSparseValues() {
        return this.contextSparseValues;
    }

    public List<Output<TInt64>> contextSparseShapes() {
        return this.contextSparseShapes;
    }

    public List<Output<?>> contextDenseValues() {
        return this.contextDenseValues;
    }

    public List<Output<?>> contextRaggedValues() {
        return this.contextRaggedValues;
    }

    public List<Output<?>> contextRaggedRowSplits() {
        return this.contextRaggedRowSplits;
    }

    public List<Output<TInt64>> featureListSparseIndices() {
        return this.featureListSparseIndices;
    }

    public List<Output<?>> featureListSparseValues() {
        return this.featureListSparseValues;
    }

    public List<Output<TInt64>> featureListSparseShapes() {
        return this.featureListSparseShapes;
    }

    public List<Output<?>> featureListDenseValues() {
        return this.featureListDenseValues;
    }

    public List<Output<TInt64>> featureListDenseLengths() {
        return this.featureListDenseLengths;
    }

    public List<Output<?>> featureListRaggedValues() {
        return this.featureListRaggedValues;
    }

    public List<Output<?>> featureListRaggedOuterSplits() {
        return this.featureListRaggedOuterSplits;
    }

    public List<Output<?>> featureListRaggedInnerSplits() {
        return this.featureListRaggedInnerSplits;
    }

    @OpInputsMetadata(outputsClass=ParseSequenceExample.class)
    public static class Inputs
    extends RawOpInputs<ParseSequenceExample> {
        public final Operand<TString> serialized;
        public final Operand<TString> debugName;
        public final Operand<TString> contextSparseKeys;
        public final Operand<TString> contextDenseKeys;
        public final Operand<TString> contextRaggedKeys;
        public final Operand<TString> featureListSparseKeys;
        public final Operand<TString> featureListDenseKeys;
        public final Operand<TString> featureListRaggedKeys;
        public final Operand<TBool> featureListDenseMissingAssumedEmpty;
        public final Iterable<Operand<?>> contextDenseDefaults;
        public final DataType[] TcontextDense;
        public final DataType[] contextSparseTypes;
        public final DataType[] contextRaggedValueTypes;
        public final DataType[] contextRaggedSplitTypes;
        public final Shape[] contextDenseShapes;
        public final DataType[] featureListDenseTypes;
        public final DataType[] featureListSparseTypes;
        public final DataType[] featureListRaggedValueTypes;
        public final DataType[] featureListRaggedSplitTypes;
        public final Shape[] featureListDenseShapes;

        public Inputs(GraphOperation op) {
            super(new ParseSequenceExample(op), op, Arrays.asList("Tcontext_dense", "context_sparse_types", "context_ragged_value_types", "context_ragged_split_types", "context_dense_shapes", "feature_list_dense_types", "feature_list_sparse_types", "feature_list_ragged_value_types", "feature_list_ragged_split_types", "feature_list_dense_shapes"));
            int inputIndex = 0;
            this.serialized = op.input(inputIndex++);
            this.debugName = op.input(inputIndex++);
            this.contextSparseKeys = op.input(inputIndex++);
            this.contextDenseKeys = op.input(inputIndex++);
            this.contextRaggedKeys = op.input(inputIndex++);
            this.featureListSparseKeys = op.input(inputIndex++);
            this.featureListDenseKeys = op.input(inputIndex++);
            this.featureListRaggedKeys = op.input(inputIndex++);
            this.featureListDenseMissingAssumedEmpty = op.input(inputIndex++);
            int contextDenseDefaultsLength = op.inputListLength("context_dense_defaults");
            this.contextDenseDefaults = Arrays.asList((Operand[])op.inputList(inputIndex, contextDenseDefaultsLength));
            inputIndex += contextDenseDefaultsLength;
            this.TcontextDense = op.attributes().getAttrTypeList("Tcontext_dense");
            this.contextSparseTypes = op.attributes().getAttrTypeList("context_sparse_types");
            this.contextRaggedValueTypes = op.attributes().getAttrTypeList("context_ragged_value_types");
            this.contextRaggedSplitTypes = op.attributes().getAttrTypeList("context_ragged_split_types");
            this.contextDenseShapes = op.attributes().getAttrShapeList("context_dense_shapes");
            this.featureListDenseTypes = op.attributes().getAttrTypeList("feature_list_dense_types");
            this.featureListSparseTypes = op.attributes().getAttrTypeList("feature_list_sparse_types");
            this.featureListRaggedValueTypes = op.attributes().getAttrTypeList("feature_list_ragged_value_types");
            this.featureListRaggedSplitTypes = op.attributes().getAttrTypeList("feature_list_ragged_split_types");
            this.featureListDenseShapes = op.attributes().getAttrShapeList("feature_list_dense_shapes");
        }
    }

    public static class Options {
        private Long NcontextSparse;
        private List<Shape> contextDenseShapes;
        private Long NfeatureListSparse;
        private Long NfeatureListDense;
        private List<Shape> featureListDenseShapes;

        private Options() {
        }

        public Options NcontextSparse(Long NcontextSparse) {
            this.NcontextSparse = NcontextSparse;
            return this;
        }

        public Options contextDenseShapes(List<Shape> contextDenseShapes) {
            this.contextDenseShapes = contextDenseShapes;
            return this;
        }

        public Options contextDenseShapes(Shape ... contextDenseShapes) {
            this.contextDenseShapes = Arrays.asList(contextDenseShapes);
            return this;
        }

        public Options NfeatureListSparse(Long NfeatureListSparse) {
            this.NfeatureListSparse = NfeatureListSparse;
            return this;
        }

        public Options NfeatureListDense(Long NfeatureListDense) {
            this.NfeatureListDense = NfeatureListDense;
            return this;
        }

        public Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
            this.featureListDenseShapes = featureListDenseShapes;
            return this;
        }

        public Options featureListDenseShapes(Shape ... featureListDenseShapes) {
            this.featureListDenseShapes = Arrays.asList(featureListDenseShapes);
            return this;
        }
    }
}

