/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="PaddingFIFOQueueV2", inputsClass=Inputs.class)
public final class PaddingFifoQueue
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "PaddingFIFOQueueV2";
    private Output<? extends TType> handle;

    public PaddingFifoQueue(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static PaddingFifoQueue create(Scope scope, List<Class<? extends TType>> componentTypes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "PaddingFifoQueue");
        opBuilder.setAttr("component_types", Operands.toDataTypes(componentTypes));
        if (options != null) {
            for (Options opts : options) {
                if (opts.shapes != null) {
                    Shape[] shapesArray = new Shape[opts.shapes.size()];
                    for (int i = 0; i < shapesArray.length; ++i) {
                        shapesArray[i] = opts.shapes.get(i);
                    }
                    opBuilder.setAttr("shapes", shapesArray);
                }
                if (opts.capacity != null) {
                    opBuilder.setAttr("capacity", opts.capacity);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new PaddingFifoQueue(opBuilder.build());
    }

    public static Options shapes(List<Shape> shapes) {
        return new Options().shapes(shapes);
    }

    public static Options shapes(Shape ... shapes) {
        return new Options().shapes(shapes);
    }

    public static Options capacity(Long capacity) {
        return new Options().capacity(capacity);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=PaddingFifoQueue.class)
    public static class Inputs
    extends RawOpInputs<PaddingFifoQueue> {
        public final DataType[] componentTypes;
        public final Shape[] shapes;
        public final long capacity;
        public final String container;
        public final String sharedName;

        public Inputs(GraphOperation op) {
            super(new PaddingFifoQueue(op), op, Arrays.asList("component_types", "shapes", "capacity", "container", "shared_name"));
            boolean inputIndex = false;
            this.componentTypes = op.attributes().getAttrTypeList("component_types");
            this.shapes = op.attributes().getAttrShapeList("shapes");
            this.capacity = op.attributes().getAttrInt("capacity");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
        }
    }

    public static class Options {
        private List<Shape> shapes;
        private Long capacity;
        private String container;
        private String sharedName;

        private Options() {
        }

        public Options shapes(List<Shape> shapes) {
            this.shapes = shapes;
            return this;
        }

        public Options shapes(Shape ... shapes) {
            this.shapes = Arrays.asList(shapes);
            return this;
        }

        public Options capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }
    }
}

