/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="ScaleAndTranslateGrad", inputsClass=Inputs.class)
public final class ScaleAndTranslateGrad<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ScaleAndTranslateGrad";
    private Output<T> output;

    public ScaleAndTranslateGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> ScaleAndTranslateGrad<T> create(Scope scope, Operand<T> grads, Operand<T> originalImage, Operand<TFloat32> scale, Operand<TFloat32> translation, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(grads.asOutput());
        opBuilder.addInput(originalImage.asOutput());
        opBuilder.addInput(scale.asOutput());
        opBuilder.addInput(translation.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.kernelType != null) {
                    opBuilder.setAttr("kernel_type", opts.kernelType);
                }
                if (opts.antialias == null) continue;
                opBuilder.setAttr("antialias", opts.antialias);
            }
        }
        return new ScaleAndTranslateGrad<T>(opBuilder.build());
    }

    public static Options kernelType(String kernelType) {
        return new Options().kernelType(kernelType);
    }

    public static Options antialias(Boolean antialias) {
        return new Options().antialias(antialias);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ScaleAndTranslateGrad.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<ScaleAndTranslateGrad<T>> {
        public final Operand<T> grads;
        public final Operand<T> originalImage;
        public final Operand<TFloat32> scale;
        public final Operand<TFloat32> translation;
        public final DataType T;
        public final String kernelType;
        public final boolean antialias;

        public Inputs(GraphOperation op) {
            super(new ScaleAndTranslateGrad(op), op, Arrays.asList("T", "kernel_type", "antialias"));
            int inputIndex = 0;
            this.grads = op.input(inputIndex++);
            this.originalImage = op.input(inputIndex++);
            this.scale = op.input(inputIndex++);
            this.translation = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.kernelType = op.attributes().getAttrString("kernel_type");
            this.antialias = op.attributes().getAttrBool("antialias");
        }
    }

    public static class Options {
        private String kernelType;
        private Boolean antialias;

        private Options() {
        }

        public Options kernelType(String kernelType) {
            this.kernelType = kernelType;
            return this;
        }

        public Options antialias(Boolean antialias) {
            this.antialias = antialias;
            return this;
        }
    }
}

