/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="NonMaxSuppressionV5", inputsClass=Inputs.class)
public final class NonMaxSuppression<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "NonMaxSuppressionV5";
    private Output<TInt32> selectedIndices;
    private Output<T> selectedScores;
    private Output<TInt32> validOutputs;

    public NonMaxSuppression(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.selectedIndices = operation.output(outputIdx++);
        this.selectedScores = operation.output(outputIdx++);
        this.validOutputs = operation.output(outputIdx++);
    }

    public static <T extends TNumber> NonMaxSuppression<T> create(Scope scope, Operand<T> boxes, Operand<T> scores, Operand<TInt32> maxOutputSize, Operand<T> iouThreshold, Operand<T> scoreThreshold, Operand<T> softNmsSigma, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "NonMaxSuppression");
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(scores.asOutput());
        opBuilder.addInput(maxOutputSize.asOutput());
        opBuilder.addInput(iouThreshold.asOutput());
        opBuilder.addInput(scoreThreshold.asOutput());
        opBuilder.addInput(softNmsSigma.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.padToMaxOutputSize == null) continue;
                opBuilder.setAttr("pad_to_max_output_size", opts.padToMaxOutputSize);
            }
        }
        return new NonMaxSuppression<T>(opBuilder.build());
    }

    public static Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
        return new Options().padToMaxOutputSize(padToMaxOutputSize);
    }

    public Output<TInt32> selectedIndices() {
        return this.selectedIndices;
    }

    public Output<T> selectedScores() {
        return this.selectedScores;
    }

    public Output<TInt32> validOutputs() {
        return this.validOutputs;
    }

    @OpInputsMetadata(outputsClass=NonMaxSuppression.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<NonMaxSuppression<T>> {
        public final Operand<T> boxes;
        public final Operand<T> scores;
        public final Operand<TInt32> maxOutputSize;
        public final Operand<T> iouThreshold;
        public final Operand<T> scoreThreshold;
        public final Operand<T> softNmsSigma;
        public final DataType T;
        public final boolean padToMaxOutputSize;

        public Inputs(GraphOperation op) {
            super(new NonMaxSuppression(op), op, Arrays.asList("T", "pad_to_max_output_size"));
            int inputIndex = 0;
            this.boxes = op.input(inputIndex++);
            this.scores = op.input(inputIndex++);
            this.maxOutputSize = op.input(inputIndex++);
            this.iouThreshold = op.input(inputIndex++);
            this.scoreThreshold = op.input(inputIndex++);
            this.softNmsSigma = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.padToMaxOutputSize = op.attributes().getAttrBool("pad_to_max_output_size");
        }
    }

    public static class Options {
        private Boolean padToMaxOutputSize;

        private Options() {
        }

        public Options padToMaxOutputSize(Boolean padToMaxOutputSize) {
            this.padToMaxOutputSize = padToMaxOutputSize;
            return this;
        }
    }
}

