/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.debugging;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DebugIdentityV2", inputsClass=Inputs.class)
public final class DebugIdentity<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "DebugIdentityV2";
    private Output<T> output;

    public DebugIdentity(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> DebugIdentity<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "DebugIdentity");
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.tfdbgContextId != null) {
                    opBuilder.setAttr("tfdbg_context_id", opts.tfdbgContextId);
                }
                if (opts.opName != null) {
                    opBuilder.setAttr("op_name", opts.opName);
                }
                if (opts.outputSlot != null) {
                    opBuilder.setAttr("output_slot", opts.outputSlot);
                }
                if (opts.tensorDebugMode != null) {
                    opBuilder.setAttr("tensor_debug_mode", opts.tensorDebugMode);
                }
                if (opts.debugUrls != null) {
                    String[] debugUrlsArray = new String[opts.debugUrls.size()];
                    for (int i = 0; i < debugUrlsArray.length; ++i) {
                        debugUrlsArray[i] = opts.debugUrls.get(i);
                    }
                    opBuilder.setAttr("debug_urls", debugUrlsArray);
                }
                if (opts.circularBufferSize != null) {
                    opBuilder.setAttr("circular_buffer_size", opts.circularBufferSize);
                }
                if (opts.tfdbgRunId == null) continue;
                opBuilder.setAttr("tfdbg_run_id", opts.tfdbgRunId);
            }
        }
        return new DebugIdentity<T>(opBuilder.build());
    }

    public static Options tfdbgContextId(String tfdbgContextId) {
        return new Options().tfdbgContextId(tfdbgContextId);
    }

    public static Options opName(String opName) {
        return new Options().opName(opName);
    }

    public static Options outputSlot(Long outputSlot) {
        return new Options().outputSlot(outputSlot);
    }

    public static Options tensorDebugMode(Long tensorDebugMode) {
        return new Options().tensorDebugMode(tensorDebugMode);
    }

    public static Options debugUrls(List<String> debugUrls) {
        return new Options().debugUrls(debugUrls);
    }

    public static Options debugUrls(String ... debugUrls) {
        return new Options().debugUrls(debugUrls);
    }

    public static Options circularBufferSize(Long circularBufferSize) {
        return new Options().circularBufferSize(circularBufferSize);
    }

    public static Options tfdbgRunId(String tfdbgRunId) {
        return new Options().tfdbgRunId(tfdbgRunId);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=DebugIdentity.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<DebugIdentity<T>> {
        public final Operand<T> input;
        public final DataType T;
        public final String tfdbgContextId;
        public final String opName;
        public final long outputSlot;
        public final long tensorDebugMode;
        public final String[] debugUrls;
        public final long circularBufferSize;
        public final String tfdbgRunId;

        public Inputs(GraphOperation op) {
            super(new DebugIdentity(op), op, Arrays.asList("T", "tfdbg_context_id", "op_name", "output_slot", "tensor_debug_mode", "debug_urls", "circular_buffer_size", "tfdbg_run_id"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.tfdbgContextId = op.attributes().getAttrString("tfdbg_context_id");
            this.opName = op.attributes().getAttrString("op_name");
            this.outputSlot = op.attributes().getAttrInt("output_slot");
            this.tensorDebugMode = op.attributes().getAttrInt("tensor_debug_mode");
            this.debugUrls = op.attributes().getAttrStringList("debug_urls");
            this.circularBufferSize = op.attributes().getAttrInt("circular_buffer_size");
            this.tfdbgRunId = op.attributes().getAttrString("tfdbg_run_id");
        }
    }

    public static class Options {
        private String tfdbgContextId;
        private String opName;
        private Long outputSlot;
        private Long tensorDebugMode;
        private List<String> debugUrls;
        private Long circularBufferSize;
        private String tfdbgRunId;

        private Options() {
        }

        public Options tfdbgContextId(String tfdbgContextId) {
            this.tfdbgContextId = tfdbgContextId;
            return this;
        }

        public Options opName(String opName) {
            this.opName = opName;
            return this;
        }

        public Options outputSlot(Long outputSlot) {
            this.outputSlot = outputSlot;
            return this;
        }

        public Options tensorDebugMode(Long tensorDebugMode) {
            this.tensorDebugMode = tensorDebugMode;
            return this;
        }

        public Options debugUrls(List<String> debugUrls) {
            this.debugUrls = debugUrls;
            return this;
        }

        public Options debugUrls(String ... debugUrls) {
            this.debugUrls = Arrays.asList(debugUrls);
            return this;
        }

        public Options circularBufferSize(Long circularBufferSize) {
            this.circularBufferSize = circularBufferSize;
            return this;
        }

        public Options tfdbgRunId(String tfdbgRunId) {
            this.tfdbgRunId = tfdbgRunId;
            return this;
        }
    }
}

