/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ExperimentalDirectedInterleaveDataset", inputsClass=Inputs.class)
public final class DirectedInterleaveDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ExperimentalDirectedInterleaveDataset";
    private Output<? extends TType> handle;

    public DirectedInterleaveDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static DirectedInterleaveDataset create(Scope scope, Operand<? extends TType> selectorInputDataset, Iterable<Operand<? extends TType>> dataInputDatasets, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "DirectedInterleaveDataset");
        opBuilder.addInput(selectorInputDataset.asOutput());
        opBuilder.addInputList(Operands.asOutputs(dataInputDatasets));
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new DirectedInterleaveDataset(opBuilder.build());
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=DirectedInterleaveDataset.class)
    public static class Inputs
    extends RawOpInputs<DirectedInterleaveDataset> {
        public final Operand<? extends TType> selectorInputDataset;
        public final Iterable<Operand<? extends TType>> dataInputDatasets;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new DirectedInterleaveDataset(op), op, Arrays.asList("output_types", "output_shapes"));
            int inputIndex = 0;
            this.selectorInputDataset = op.input(inputIndex++);
            int dataInputDatasetsLength = op.inputListLength("data_input_datasets");
            this.dataInputDatasets = Arrays.asList((Operand[])op.inputList(inputIndex, dataInputDatasetsLength));
            inputIndex += dataInputDatasetsLength;
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }
}

