/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ExperimentalChooseFastestDataset", inputsClass=Inputs.class)
public final class ChooseFastestDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ExperimentalChooseFastestDataset";
    private Output<? extends TType> handle;

    public ChooseFastestDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static ChooseFastestDataset create(Scope scope, Iterable<Operand<? extends TType>> inputDatasets, Long numExperiments, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "ChooseFastestDataset");
        opBuilder.addInputList(Operands.asOutputs(inputDatasets));
        opBuilder.setAttr("num_experiments", numExperiments);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new ChooseFastestDataset(opBuilder.build());
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=ChooseFastestDataset.class)
    public static class Inputs
    extends RawOpInputs<ChooseFastestDataset> {
        public final Iterable<Operand<? extends TType>> inputDatasets;
        public final long numExperiments;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new ChooseFastestDataset(op), op, Arrays.asList("num_experiments", "output_types", "output_shapes"));
            int inputIndex = 0;
            int inputDatasetsLength = op.inputListLength("input_datasets");
            this.inputDatasets = Arrays.asList((Operand[])op.inputList(inputIndex, inputDatasetsLength));
            inputIndex += inputDatasetsLength;
            this.numExperiments = op.attributes().getAttrInt("num_experiments");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }
}

