/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="BarrierTakeMany", inputsClass=Inputs.class)
public final class BarrierTakeMany
extends RawOp {
    public static final String OP_NAME = "BarrierTakeMany";
    private Output<TInt64> indices;
    private Output<TString> keys;
    private List<Output<?>> values;

    public BarrierTakeMany(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.indices = operation.output(outputIdx++);
        this.keys = operation.output(outputIdx++);
        int valuesLength = operation.outputListLength("values");
        this.values = Arrays.asList(operation.outputList(outputIdx, valuesLength));
        outputIdx += valuesLength;
    }

    public static BarrierTakeMany create(Scope scope, Operand<TString> handle, Operand<TInt32> numElements, List<Class<? extends TType>> componentTypes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(numElements.asOutput());
        opBuilder.setAttr("component_types", Operands.toDataTypes(componentTypes));
        if (options != null) {
            for (Options opts : options) {
                if (opts.allowSmallBatch != null) {
                    opBuilder.setAttr("allow_small_batch", opts.allowSmallBatch);
                }
                if (opts.waitForIncomplete != null) {
                    opBuilder.setAttr("wait_for_incomplete", opts.waitForIncomplete);
                }
                if (opts.timeoutMs == null) continue;
                opBuilder.setAttr("timeout_ms", opts.timeoutMs);
            }
        }
        return new BarrierTakeMany(opBuilder.build());
    }

    public static Options allowSmallBatch(Boolean allowSmallBatch) {
        return new Options().allowSmallBatch(allowSmallBatch);
    }

    public static Options waitForIncomplete(Boolean waitForIncomplete) {
        return new Options().waitForIncomplete(waitForIncomplete);
    }

    public static Options timeoutMs(Long timeoutMs) {
        return new Options().timeoutMs(timeoutMs);
    }

    public Output<TInt64> indices() {
        return this.indices;
    }

    public Output<TString> keys() {
        return this.keys;
    }

    public List<Output<?>> values() {
        return this.values;
    }

    @OpInputsMetadata(outputsClass=BarrierTakeMany.class)
    public static class Inputs
    extends RawOpInputs<BarrierTakeMany> {
        public final Operand<TString> handle;
        public final Operand<TInt32> numElements;
        public final DataType[] componentTypes;
        public final boolean allowSmallBatch;
        public final boolean waitForIncomplete;
        public final long timeoutMs;

        public Inputs(GraphOperation op) {
            super(new BarrierTakeMany(op), op, Arrays.asList("component_types", "allow_small_batch", "wait_for_incomplete", "timeout_ms"));
            int inputIndex = 0;
            this.handle = op.input(inputIndex++);
            this.numElements = op.input(inputIndex++);
            this.componentTypes = op.attributes().getAttrTypeList("component_types");
            this.allowSmallBatch = op.attributes().getAttrBool("allow_small_batch");
            this.waitForIncomplete = op.attributes().getAttrBool("wait_for_incomplete");
            this.timeoutMs = op.attributes().getAttrInt("timeout_ms");
        }
    }

    public static class Options {
        private Boolean allowSmallBatch;
        private Boolean waitForIncomplete;
        private Long timeoutMs;

        private Options() {
        }

        public Options allowSmallBatch(Boolean allowSmallBatch) {
            this.allowSmallBatch = allowSmallBatch;
            return this;
        }

        public Options waitForIncomplete(Boolean waitForIncomplete) {
            this.waitForIncomplete = waitForIncomplete;
            return this;
        }

        public Options timeoutMs(Long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }
    }
}

