/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.dense;

import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.ShortNdArray;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.impl.dense.AbstractDenseNdArray;
import org.tensorflow.ndarray.impl.dense.DataTransfer;
import org.tensorflow.ndarray.impl.dense.Validator;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;

public class ShortDenseNdArray
extends AbstractDenseNdArray<Short, ShortNdArray>
implements ShortNdArray {
    private final ShortDataBuffer buffer;

    public static ShortNdArray create(ShortDataBuffer buffer, Shape shape) {
        Validator.denseShape(buffer, shape);
        return new ShortDenseNdArray(buffer, shape);
    }

    @Override
    public short getShort(long ... indices) {
        return this.buffer.getShort(this.positionOf(indices, true));
    }

    @Override
    public ShortNdArray setShort(short value, long ... indices) {
        this.buffer.setShort(value, this.positionOf(indices, true));
        return this;
    }

    @Override
    public ShortNdArray copyTo(NdArray<Short> dst) {
        Validator.copyToNdArrayArgs(this, dst);
        if (dst instanceof ShortDenseNdArray) {
            ShortDenseNdArray shortDst = (ShortDenseNdArray)dst;
            DataTransfer.execute(this.buffer, this.dimensions(), shortDst.buffer, shortDst.dimensions(), DataTransfer::ofShort);
        } else {
            this.slowCopyTo(dst);
        }
        return this;
    }

    @Override
    public ShortNdArray read(ShortDataBuffer dst) {
        Validator.readToBufferArgs(this, dst);
        DataTransfer.execute(this.buffer, this.dimensions(), dst, DataTransfer::ofShort);
        return this;
    }

    @Override
    public ShortNdArray write(ShortDataBuffer src) {
        Validator.writeFromBufferArgs(this, src);
        DataTransfer.execute(src, this.buffer, this.dimensions(), DataTransfer::ofShort);
        return this;
    }

    protected ShortDenseNdArray(ShortDataBuffer buffer, Shape shape) {
        this(buffer, DimensionalSpace.create(shape));
    }

    @Override
    ShortDenseNdArray instantiate(DataBuffer<Short> buffer, DimensionalSpace dimensions) {
        return new ShortDenseNdArray((ShortDataBuffer)buffer, dimensions);
    }

    protected ShortDataBuffer buffer() {
        return this.buffer;
    }

    private ShortDenseNdArray(ShortDataBuffer buffer, DimensionalSpace dimensions) {
        super(dimensions);
        this.buffer = buffer;
    }
}

