/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.dense;

import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.impl.dense.AbstractDenseNdArray;
import org.tensorflow.ndarray.impl.dense.DataTransfer;
import org.tensorflow.ndarray.impl.dense.Validator;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;

public class LongDenseNdArray
extends AbstractDenseNdArray<Long, LongNdArray>
implements LongNdArray {
    private final LongDataBuffer buffer;

    public static LongNdArray create(LongDataBuffer buffer, Shape shape) {
        Validator.denseShape(buffer, shape);
        return new LongDenseNdArray(buffer, shape);
    }

    @Override
    public long getLong(long ... indices) {
        return this.buffer.getLong(this.positionOf(indices, true));
    }

    @Override
    public LongNdArray setLong(long value, long ... indices) {
        this.buffer.setLong(value, this.positionOf(indices, true));
        return this;
    }

    @Override
    public LongNdArray copyTo(NdArray<Long> dst) {
        Validator.copyToNdArrayArgs(this, dst);
        if (dst instanceof LongDenseNdArray) {
            LongDenseNdArray longDst = (LongDenseNdArray)dst;
            DataTransfer.execute(this.buffer, this.dimensions(), longDst.buffer, longDst.dimensions(), DataTransfer::ofLong);
        } else {
            this.slowCopyTo(dst);
        }
        return this;
    }

    @Override
    public LongNdArray read(LongDataBuffer dst) {
        Validator.readToBufferArgs(this, dst);
        DataTransfer.execute(this.buffer, this.dimensions(), dst, DataTransfer::ofLong);
        return this;
    }

    @Override
    public LongNdArray write(LongDataBuffer src) {
        Validator.writeFromBufferArgs(this, src);
        DataTransfer.execute(src, this.buffer, this.dimensions(), DataTransfer::ofLong);
        return this;
    }

    protected LongDenseNdArray(LongDataBuffer buffer, Shape shape) {
        this(buffer, DimensionalSpace.create(shape));
    }

    @Override
    LongDenseNdArray instantiate(DataBuffer<Long> buffer, DimensionalSpace dimensions) {
        return new LongDenseNdArray((LongDataBuffer)buffer, dimensions);
    }

    protected LongDataBuffer buffer() {
        return this.buffer;
    }

    private LongDenseNdArray(LongDataBuffer buffer, DimensionalSpace dimensions) {
        super(dimensions);
        this.buffer = buffer;
    }
}

