/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="StringToNumber", inputsClass=Inputs.class)
public final class ToNumber<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "StringToNumber";
    private Output<T> output;

    public ToNumber(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> ToNumber<T> create(Scope scope, Operand<TString> stringTensor, Class<T> outType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "ToNumber");
        opBuilder.addInput(stringTensor.asOutput());
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        return new ToNumber<T>(opBuilder.build());
    }

    public static ToNumber<TFloat32> create(Scope scope, Operand<TString> stringTensor) {
        return ToNumber.create(scope, stringTensor, TFloat32.class);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ToNumber.class)
    public static class Inputs
    extends RawOpInputs<ToNumber<?>> {
        public final Operand<TString> stringTensor;
        public final DataType outType;

        public Inputs(GraphOperation op) {
            super(new ToNumber(op), op, Arrays.asList("out_type"));
            int inputIndex = 0;
            this.stringTensor = op.input(inputIndex++);
            this.outType = op.attributes().getAttrType("out_type");
        }
    }
}

