/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ExperimentalTakeWhileDataset", inputsClass=Inputs.class)
public final class TakeWhileDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ExperimentalTakeWhileDataset";
    private Output<? extends TType> handle;

    public TakeWhileDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static TakeWhileDataset create(Scope scope, Operand<? extends TType> inputDataset, Iterable<Operand<?>> otherArguments, ConcreteFunction predicate, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "TakeWhileDataset");
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInputList(Operands.asOutputs(otherArguments));
        opBuilder.setAttr("predicate", predicate);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new TakeWhileDataset(opBuilder.build());
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=TakeWhileDataset.class)
    public static class Inputs
    extends RawOpInputs<TakeWhileDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Iterable<Operand<?>> otherArguments;
        public final DataType[] Targuments;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new TakeWhileDataset(op), op, Arrays.asList("Targuments", "output_types", "output_shapes"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            int otherArgumentsLength = op.inputListLength("other_arguments");
            this.otherArguments = Arrays.asList((Operand[])op.inputList(inputIndex, otherArgumentsLength));
            inputIndex += otherArgumentsLength;
            this.Targuments = op.attributes().getAttrTypeList("Targuments");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }
}

