/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorArrayGradV3", inputsClass=Inputs.class)
public final class TensorArrayGrad
extends RawOp {
    public static final String OP_NAME = "TensorArrayGradV3";
    private Output<? extends TType> gradHandle;
    private Output<TFloat32> flowOut;

    public TensorArrayGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.gradHandle = operation.output(outputIdx++);
        this.flowOut = operation.output(outputIdx++);
    }

    public static TensorArrayGrad create(Scope scope, Operand<? extends TType> handle, Operand<TFloat32> flowIn, String source) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "TensorArrayGrad");
        opBuilder.addInput(handle.asOutput());
        opBuilder.addInput(flowIn.asOutput());
        opBuilder.setAttr("source", source);
        return new TensorArrayGrad(opBuilder.build());
    }

    public Output<? extends TType> gradHandle() {
        return this.gradHandle;
    }

    public Output<TFloat32> flowOut() {
        return this.flowOut;
    }

    @OpInputsMetadata(outputsClass=TensorArrayGrad.class)
    public static class Inputs
    extends RawOpInputs<TensorArrayGrad> {
        public final Operand<? extends TType> handle;
        public final Operand<TFloat32> flowIn;
        public final String source;

        public Inputs(GraphOperation op) {
            super(new TensorArrayGrad(op), op, Arrays.asList("source"));
            int inputIndex = 0;
            this.handle = op.input(inputIndex++);
            this.flowIn = op.input(inputIndex++);
            this.source = op.attributes().getAttrString("source");
        }
    }
}

