/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.ArrayList;
import java.util.List;
import org.tensorflow.DeviceSpec;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.NameScope;
import org.tensorflow.op.Scope;

public final class OpScope
implements Scope {
    private final ExecutionEnvironment env;
    private final List<Operation> controlDependencies;
    private final NameScope nameScope;
    private final DeviceSpec deviceSpec;
    private final boolean isInit;

    public OpScope(ExecutionEnvironment env) {
        this(env, new NameScope(env), new ArrayList<Operation>(), DeviceSpec.newBuilder().build(), false);
    }

    @Override
    public ExecutionEnvironment env() {
        return this.env;
    }

    @Override
    public OpScope withSubScope(String childScopeName) {
        return new OpScope(this.env, this.nameScope.withSubScope(childScopeName, this.env), this.controlDependencies, this.deviceSpec, this.isInit);
    }

    @Override
    public OpScope withName(String opName) {
        return new OpScope(this.env, this.nameScope.withName(opName), this.controlDependencies, this.deviceSpec, this.isInit);
    }

    @Override
    public OpScope withNameAsSubScope(String defaultName) {
        return new OpScope(this.env, this.nameScope.withSubScope(this.nameScope.makeOpName(defaultName), this.env), this.controlDependencies, this.deviceSpec, this.isInit);
    }

    @Override
    public OpScope withDevice(DeviceSpec newDevice) {
        return new OpScope(this.env, this.nameScope, this.controlDependencies, newDevice, this.isInit);
    }

    @Override
    public OpScope withInitScope() {
        return new OpScope(this.env, this.nameScope, new ArrayList<Operation>(), this.deviceSpec, true);
    }

    @Override
    public String makeOpName(String defaultName) {
        return this.nameScope.makeOpName(defaultName);
    }

    @Override
    public String makeUnique(String id) {
        return this.nameScope.makeUnique(id);
    }

    @Override
    public void refreshNames() {
        this.nameScope.importIdsFrom(this.env);
    }

    private OpScope(ExecutionEnvironment env, NameScope nameScope, List<Operation> controlDependencies, DeviceSpec deviceSpec, boolean isInit) {
        this.env = env;
        this.nameScope = nameScope;
        this.controlDependencies = controlDependencies;
        this.deviceSpec = deviceSpec;
        this.isInit = isInit;
    }

    @Override
    public Scope withControlDependencyOps(Iterable<Operation> controls) {
        ArrayList<Operation> toAdd = new ArrayList<Operation>();
        for (Operation control : controls) {
            this.env.checkInput(control);
            if (this.isInit && !this.env.isInitializer(control)) {
                throw new IllegalArgumentException("Init scope can not have non-init control dependency.");
            }
            if (!this.isInit && this.env.isInitializer(control)) continue;
            toAdd.add(control);
        }
        return new OpScope(this.env, this.nameScope, toAdd, this.deviceSpec, this.isInit);
    }

    @Override
    public OperationBuilder apply(OperationBuilder builder) {
        builder.setDevice(this.deviceSpec.toString());
        for (Operation control : this.controlDependencies) {
            if (!this.isInit && this.env.isInitializer(control)) continue;
            builder.addControlInput(control);
        }
        return builder;
    }

    @Override
    public boolean isInit() {
        return this.isInit;
    }

    @Override
    public String getDeviceString() {
        return this.deviceSpec.toString();
    }
}

