/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="MapPeek", inputsClass=Inputs.class)
public final class MapPeek
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "MapPeek";
    private List<Output<?>> values;

    public MapPeek(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int valuesLength = operation.outputListLength("values");
        this.values = Arrays.asList(operation.outputList(outputIdx, valuesLength));
        outputIdx += valuesLength;
    }

    public static MapPeek create(Scope scope, Operand<TInt64> key, Operand<TInt32> indices, List<Class<? extends TType>> dtypes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(key.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.setAttr("dtypes", Operands.toDataTypes(dtypes));
        if (options != null) {
            for (Options opts : options) {
                if (opts.capacity != null) {
                    opBuilder.setAttr("capacity", opts.capacity);
                }
                if (opts.memoryLimit != null) {
                    opBuilder.setAttr("memory_limit", opts.memoryLimit);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new MapPeek(opBuilder.build());
    }

    public static Options capacity(Long capacity) {
        return new Options().capacity(capacity);
    }

    public static Options memoryLimit(Long memoryLimit) {
        return new Options().memoryLimit(memoryLimit);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public List<Output<?>> values() {
        return this.values;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.values.iterator();
    }

    @OpInputsMetadata(outputsClass=MapPeek.class)
    public static class Inputs
    extends RawOpInputs<MapPeek> {
        public final Operand<TInt64> key;
        public final Operand<TInt32> indices;
        public final long capacity;
        public final long memoryLimit;
        public final DataType[] dtypes;
        public final String container;
        public final String sharedName;

        public Inputs(GraphOperation op) {
            super(new MapPeek(op), op, Arrays.asList("capacity", "memory_limit", "dtypes", "container", "shared_name"));
            int inputIndex = 0;
            this.key = op.input(inputIndex++);
            this.indices = op.input(inputIndex++);
            this.capacity = op.attributes().getAttrInt("capacity");
            this.memoryLimit = op.attributes().getAttrInt("memory_limit");
            this.dtypes = op.attributes().getAttrTypeList("dtypes");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
        }
    }

    public static class Options {
        private Long capacity;
        private Long memoryLimit;
        private String container;
        private String sharedName;

        private Options() {
        }

        public Options capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Options memoryLimit(Long memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }
    }
}

