/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Copy", inputsClass=Inputs.class)
public final class Copy<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Copy";
    private Output<T> output;

    public Copy(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> Copy<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.tensorName != null) {
                    opBuilder.setAttr("tensor_name", opts.tensorName);
                }
                if (opts.debugOpsSpec == null) continue;
                String[] debugOpsSpecArray = new String[opts.debugOpsSpec.size()];
                for (int i = 0; i < debugOpsSpecArray.length; ++i) {
                    debugOpsSpecArray[i] = opts.debugOpsSpec.get(i);
                }
                opBuilder.setAttr("debug_ops_spec", debugOpsSpecArray);
            }
        }
        return new Copy<T>(opBuilder.build());
    }

    public static Options tensorName(String tensorName) {
        return new Options().tensorName(tensorName);
    }

    public static Options debugOpsSpec(List<String> debugOpsSpec) {
        return new Options().debugOpsSpec(debugOpsSpec);
    }

    public static Options debugOpsSpec(String ... debugOpsSpec) {
        return new Options().debugOpsSpec(debugOpsSpec);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Copy.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Copy<T>> {
        public final Operand<T> input;
        public final DataType T;
        public final String tensorName;
        public final String[] debugOpsSpec;

        public Inputs(GraphOperation op) {
            super(new Copy(op), op, Arrays.asList("T", "tensor_name", "debug_ops_spec"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.tensorName = op.attributes().getAttrString("tensor_name");
            this.debugOpsSpec = op.attributes().getAttrStringList("debug_ops_spec");
        }
    }

    public static class Options {
        private String tensorName;
        private List<String> debugOpsSpec;

        private Options() {
        }

        public Options tensorName(String tensorName) {
            this.tensorName = tensorName;
            return this;
        }

        public Options debugOpsSpec(List<String> debugOpsSpec) {
            this.debugOpsSpec = debugOpsSpec;
            return this;
        }

        public Options debugOpsSpec(String ... debugOpsSpec) {
            this.debugOpsSpec = Arrays.asList(debugOpsSpec);
            return this;
        }
    }
}

