/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;

@OpMetadata(opType="TPUReplicateMetadata", inputsClass=Inputs.class)
@Deprecated
public final class TPUReplicateMetadata
extends RawOp {
    public static final String OP_NAME = "TPUReplicateMetadata";

    public TPUReplicateMetadata(Operation operation) {
        super(operation, OP_NAME);
    }

    public static TPUReplicateMetadata create(Scope scope, Long numReplicas, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("num_replicas", numReplicas);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.numCoresPerReplica != null) {
                    opBuilder.setAttr("num_cores_per_replica", opts.numCoresPerReplica);
                }
                if (opts.topology != null) {
                    opBuilder.setAttr("topology", opts.topology);
                }
                if (opts.useTpu != null) {
                    opBuilder.setAttr("use_tpu", opts.useTpu);
                }
                if (opts.deviceAssignment != null) {
                    long[] deviceAssignmentArray = new long[opts.deviceAssignment.size()];
                    for (i = 0; i < deviceAssignmentArray.length; ++i) {
                        deviceAssignmentArray[i] = (Long)opts.deviceAssignment.get(i);
                    }
                    opBuilder.setAttr("device_assignment", deviceAssignmentArray);
                }
                if (opts.computationShape != null) {
                    long[] computationShapeArray = new long[opts.computationShape.size()];
                    for (i = 0; i < computationShapeArray.length; ++i) {
                        computationShapeArray[i] = (Long)opts.computationShape.get(i);
                    }
                    opBuilder.setAttr("computation_shape", computationShapeArray);
                }
                if (opts.hostComputeCore != null) {
                    String[] hostComputeCoreArray = new String[opts.hostComputeCore.size()];
                    for (i = 0; i < hostComputeCoreArray.length; ++i) {
                        hostComputeCoreArray[i] = (String)opts.hostComputeCore.get(i);
                    }
                    opBuilder.setAttr("host_compute_core", hostComputeCoreArray);
                }
                if (opts.paddingMap != null) {
                    String[] paddingMapArray = new String[opts.paddingMap.size()];
                    for (i = 0; i < paddingMapArray.length; ++i) {
                        paddingMapArray[i] = (String)opts.paddingMap.get(i);
                    }
                    opBuilder.setAttr("padding_map", paddingMapArray);
                }
                if (opts.stepMarkerLocation != null) {
                    opBuilder.setAttr("step_marker_location", opts.stepMarkerLocation);
                }
                if (opts.allowSoftPlacement != null) {
                    opBuilder.setAttr("allow_soft_placement", opts.allowSoftPlacement);
                }
                if (opts.useSpmdForXlaPartitioning == null) continue;
                opBuilder.setAttr("use_spmd_for_xla_partitioning", opts.useSpmdForXlaPartitioning);
            }
        }
        return new TPUReplicateMetadata(opBuilder.build());
    }

    public static Options numCoresPerReplica(Long numCoresPerReplica) {
        return new Options().numCoresPerReplica(numCoresPerReplica);
    }

    public static Options topology(String topology) {
        return new Options().topology(topology);
    }

    public static Options useTpu(Boolean useTpu) {
        return new Options().useTpu(useTpu);
    }

    public static Options deviceAssignment(List<Long> deviceAssignment) {
        return new Options().deviceAssignment(deviceAssignment);
    }

    public static Options deviceAssignment(Long ... deviceAssignment) {
        return new Options().deviceAssignment(deviceAssignment);
    }

    public static Options computationShape(List<Long> computationShape) {
        return new Options().computationShape(computationShape);
    }

    public static Options computationShape(Long ... computationShape) {
        return new Options().computationShape(computationShape);
    }

    public static Options hostComputeCore(List<String> hostComputeCore) {
        return new Options().hostComputeCore(hostComputeCore);
    }

    public static Options hostComputeCore(String ... hostComputeCore) {
        return new Options().hostComputeCore(hostComputeCore);
    }

    public static Options paddingMap(List<String> paddingMap) {
        return new Options().paddingMap(paddingMap);
    }

    public static Options paddingMap(String ... paddingMap) {
        return new Options().paddingMap(paddingMap);
    }

    public static Options stepMarkerLocation(String stepMarkerLocation) {
        return new Options().stepMarkerLocation(stepMarkerLocation);
    }

    public static Options allowSoftPlacement(Boolean allowSoftPlacement) {
        return new Options().allowSoftPlacement(allowSoftPlacement);
    }

    public static Options useSpmdForXlaPartitioning(Boolean useSpmdForXlaPartitioning) {
        return new Options().useSpmdForXlaPartitioning(useSpmdForXlaPartitioning);
    }

    @OpInputsMetadata(outputsClass=TPUReplicateMetadata.class)
    public static class Inputs
    extends RawOpInputs<TPUReplicateMetadata> {
        public final long numReplicas;
        public final long numCoresPerReplica;
        public final String topology;
        public final boolean useTpu;
        public final long[] deviceAssignment;
        public final long[] computationShape;
        public final String[] hostComputeCore;
        public final String[] paddingMap;
        public final String stepMarkerLocation;
        public final boolean allowSoftPlacement;
        public final boolean useSpmdForXlaPartitioning;

        public Inputs(GraphOperation op) {
            super(new TPUReplicateMetadata(op), op, Arrays.asList("num_replicas", "num_cores_per_replica", "topology", "use_tpu", "device_assignment", "computation_shape", "host_compute_core", "padding_map", "step_marker_location", "allow_soft_placement", "use_spmd_for_xla_partitioning"));
            boolean inputIndex = false;
            this.numReplicas = op.attributes().getAttrInt("num_replicas");
            this.numCoresPerReplica = op.attributes().getAttrInt("num_cores_per_replica");
            this.topology = op.attributes().getAttrString("topology");
            this.useTpu = op.attributes().getAttrBool("use_tpu");
            this.deviceAssignment = op.attributes().getAttrIntList("device_assignment");
            this.computationShape = op.attributes().getAttrIntList("computation_shape");
            this.hostComputeCore = op.attributes().getAttrStringList("host_compute_core");
            this.paddingMap = op.attributes().getAttrStringList("padding_map");
            this.stepMarkerLocation = op.attributes().getAttrString("step_marker_location");
            this.allowSoftPlacement = op.attributes().getAttrBool("allow_soft_placement");
            this.useSpmdForXlaPartitioning = op.attributes().getAttrBool("use_spmd_for_xla_partitioning");
        }
    }

    public static class Options {
        private Long numCoresPerReplica;
        private String topology;
        private Boolean useTpu;
        private List<Long> deviceAssignment;
        private List<Long> computationShape;
        private List<String> hostComputeCore;
        private List<String> paddingMap;
        private String stepMarkerLocation;
        private Boolean allowSoftPlacement;
        private Boolean useSpmdForXlaPartitioning;

        private Options() {
        }

        public Options numCoresPerReplica(Long numCoresPerReplica) {
            this.numCoresPerReplica = numCoresPerReplica;
            return this;
        }

        public Options topology(String topology) {
            this.topology = topology;
            return this;
        }

        public Options useTpu(Boolean useTpu) {
            this.useTpu = useTpu;
            return this;
        }

        public Options deviceAssignment(List<Long> deviceAssignment) {
            this.deviceAssignment = deviceAssignment;
            return this;
        }

        public Options deviceAssignment(Long ... deviceAssignment) {
            this.deviceAssignment = Arrays.asList(deviceAssignment);
            return this;
        }

        public Options computationShape(List<Long> computationShape) {
            this.computationShape = computationShape;
            return this;
        }

        public Options computationShape(Long ... computationShape) {
            this.computationShape = Arrays.asList(computationShape);
            return this;
        }

        public Options hostComputeCore(List<String> hostComputeCore) {
            this.hostComputeCore = hostComputeCore;
            return this;
        }

        public Options hostComputeCore(String ... hostComputeCore) {
            this.hostComputeCore = Arrays.asList(hostComputeCore);
            return this;
        }

        public Options paddingMap(List<String> paddingMap) {
            this.paddingMap = paddingMap;
            return this;
        }

        public Options paddingMap(String ... paddingMap) {
            this.paddingMap = Arrays.asList(paddingMap);
            return this;
        }

        public Options stepMarkerLocation(String stepMarkerLocation) {
            this.stepMarkerLocation = stepMarkerLocation;
            return this;
        }

        public Options allowSoftPlacement(Boolean allowSoftPlacement) {
            this.allowSoftPlacement = allowSoftPlacement;
            return this;
        }

        public Options useSpmdForXlaPartitioning(Boolean useSpmdForXlaPartitioning) {
            this.useSpmdForXlaPartitioning = useSpmdForXlaPartitioning;
            return this;
        }
    }
}

