/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseToDense", inputsClass=Inputs.class)
public final class SparseToDense<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "SparseToDense";
    private Output<U> dense;

    public SparseToDense(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.dense = operation.output(outputIdx++);
    }

    public static <U extends TType, T extends TNumber> SparseToDense<U> create(Scope scope, Operand<T> sparseIndices, Operand<T> outputShape, Operand<U> sparseValues, Operand<U> defaultValue, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(sparseIndices.asOutput());
        opBuilder.addInput(outputShape.asOutput());
        opBuilder.addInput(sparseValues.asOutput());
        opBuilder.addInput(defaultValue.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.validateIndices == null) continue;
                opBuilder.setAttr("validate_indices", opts.validateIndices);
            }
        }
        return new SparseToDense<U>(opBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public Output<U> dense() {
        return this.dense;
    }

    @Override
    public Output<U> asOutput() {
        return this.dense;
    }

    @OpInputsMetadata(outputsClass=SparseToDense.class)
    public static class Inputs<T extends TNumber, U extends TType>
    extends RawOpInputs<SparseToDense<U>> {
        public final Operand<T> sparseIndices;
        public final Operand<T> outputShape;
        public final Operand<U> sparseValues;
        public final Operand<U> defaultValue;
        public final boolean validateIndices;
        public final DataType T;
        public final DataType Tindices;

        public Inputs(GraphOperation op) {
            super(new SparseToDense(op), op, Arrays.asList("validate_indices", "T", "Tindices"));
            int inputIndex = 0;
            this.sparseIndices = op.input(inputIndex++);
            this.outputShape = op.input(inputIndex++);
            this.sparseValues = op.input(inputIndex++);
            this.defaultValue = op.input(inputIndex++);
            this.validateIndices = op.attributes().getAttrBool("validate_indices");
            this.T = op.attributes().getAttrType("T");
            this.Tindices = op.attributes().getAttrType("Tindices");
        }
    }

    public static class Options {
        private Boolean validateIndices;

        private Options() {
        }

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }
    }
}

