/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="VarHandleOp", inputsClass=Inputs.class)
public final class VarHandleOp
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "VarHandleOp";
    private Output<? extends TType> resource;

    public VarHandleOp(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.resource = operation.output(outputIdx++);
    }

    public static <T extends TType> VarHandleOp create(Scope scope, Class<T> dtype, Shape shape, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        opBuilder.setAttr("shape", shape);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.allowedDevices == null) continue;
                String[] allowedDevicesArray = new String[opts.allowedDevices.size()];
                for (int i = 0; i < allowedDevicesArray.length; ++i) {
                    allowedDevicesArray[i] = (String)opts.allowedDevices.get(i);
                }
                opBuilder.setAttr("allowed_devices", allowedDevicesArray);
            }
        }
        return new VarHandleOp(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options allowedDevices(List<String> allowedDevices) {
        return new Options().allowedDevices(allowedDevices);
    }

    public static Options allowedDevices(String ... allowedDevices) {
        return new Options().allowedDevices(allowedDevices);
    }

    public Output<? extends TType> resource() {
        return this.resource;
    }

    @Override
    public Output<TType> asOutput() {
        return this.resource;
    }

    @OpInputsMetadata(outputsClass=VarHandleOp.class)
    public static class Inputs
    extends RawOpInputs<VarHandleOp> {
        public final String container;
        public final String sharedName;
        public final DataType dtype;
        public final Shape shape;
        public final String[] allowedDevices;

        public Inputs(GraphOperation op) {
            super(new VarHandleOp(op), op, Arrays.asList("container", "shared_name", "dtype", "shape", "allowed_devices"));
            boolean inputIndex = false;
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
            this.dtype = op.attributes().getAttrType("dtype");
            this.shape = op.attributes().getAttrShape("shape");
            this.allowedDevices = op.attributes().getAttrStringList("allowed_devices");
        }
    }

    public static class Options {
        private String container;
        private String sharedName;
        private List<String> allowedDevices;

        private Options() {
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options allowedDevices(List<String> allowedDevices) {
            this.allowedDevices = allowedDevices;
            return this;
        }

        public Options allowedDevices(String ... allowedDevices) {
            this.allowedDevices = Arrays.asList(allowedDevices);
            return this;
        }
    }
}

