/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ResourceGatherNd", inputsClass=Inputs.class)
public final class ResourceGatherNd<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "ResourceGatherNd";
    private Output<U> output;

    public ResourceGatherNd(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TType> ResourceGatherNd<U> create(Scope scope, Operand<? extends TType> resource, Operand<? extends TNumber> indices, Class<U> dtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(resource.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        return new ResourceGatherNd<U>(opBuilder.build());
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ResourceGatherNd.class)
    public static class Inputs
    extends RawOpInputs<ResourceGatherNd<?>> {
        public final Operand<? extends TType> resource;
        public final Operand<? extends TNumber> indices;
        public final DataType dtype;
        public final DataType Tindices;

        public Inputs(GraphOperation op) {
            super(new ResourceGatherNd(op), op, Arrays.asList("dtype", "Tindices"));
            int inputIndex = 0;
            this.resource = op.input(inputIndex++);
            this.indices = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
            this.Tindices = op.attributes().getAttrType("Tindices");
        }
    }
}

