/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.tensorflow.RawTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.impl.dense.BooleanDenseNdArray;
import org.tensorflow.types.TBool;

public final class TBoolMapper
extends TensorMapper<TBool> {
    @Override
    protected TBool mapDense(RawTensor tensor) {
        BooleanDataBuffer buffer = TensorBuffers.toBooleans(TBoolMapper.nativeHandle(tensor));
        return new DenseTBool(tensor, buffer);
    }

    private static final class DenseTBool
    extends BooleanDenseNdArray
    implements TBool {
        final RawTensor rawTensor;

        public Class<TBool> type() {
            return TBool.class;
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTBool(RawTensor rawTensor, BooleanDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

