/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaEinsum", inputsClass=Inputs.class)
public final class Einsum<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaEinsum";
    private Output<T> product;

    public Einsum(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.product = operation.output(outputIdx++);
    }

    public static <T extends TType> Einsum<T> create(Scope scope, Operand<T> a, Operand<T> b, String equation) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Einsum");
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        opBuilder.setAttr("equation", equation);
        return new Einsum<T>(opBuilder.build());
    }

    public Output<T> product() {
        return this.product;
    }

    @Override
    public Output<T> asOutput() {
        return this.product;
    }

    @OpInputsMetadata(outputsClass=Einsum.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Einsum<T>> {
        public final Operand<T> a;
        public final Operand<T> b;
        public final String equation;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new Einsum(op), op, Arrays.asList("equation", "T"));
            int inputIndex = 0;
            this.a = op.input(inputIndex++);
            this.b = op.input(inputIndex++);
            this.equation = op.attributes().getAttrString("equation");
            this.T = op.attributes().getAttrType("T");
        }
    }
}

