/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="InfeedEnqueue", inputsClass=Inputs.class)
public final class InfeedEnqueue
extends RawOp {
    public static final String OP_NAME = "InfeedEnqueue";

    public InfeedEnqueue(Operation operation) {
        super(operation, OP_NAME);
    }

    public static InfeedEnqueue create(Scope scope, Operand<? extends TType> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.shape != null) {
                    opBuilder.setAttr("shape", opts.shape);
                }
                if (opts.layout != null) {
                    long[] layoutArray = new long[opts.layout.size()];
                    for (int i = 0; i < layoutArray.length; ++i) {
                        layoutArray[i] = (Long)opts.layout.get(i);
                    }
                    opBuilder.setAttr("layout", layoutArray);
                }
                if (opts.deviceOrdinal == null) continue;
                opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
            }
        }
        return new InfeedEnqueue(opBuilder.build());
    }

    public static Options shape(Shape shape) {
        return new Options().shape(shape);
    }

    public static Options layout(List<Long> layout) {
        return new Options().layout(layout);
    }

    public static Options layout(Long ... layout) {
        return new Options().layout(layout);
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    @OpInputsMetadata(outputsClass=InfeedEnqueue.class)
    public static class Inputs
    extends RawOpInputs<InfeedEnqueue> {
        public final Operand<? extends TType> input;
        public final DataType dtype;
        public final Shape shape;
        public final long[] layout;
        public final long deviceOrdinal;

        public Inputs(GraphOperation op) {
            super(new InfeedEnqueue(op), op, Arrays.asList("dtype", "shape", "layout", "device_ordinal"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
            this.shape = op.attributes().getAttrShape("shape");
            this.layout = op.attributes().getAttrIntList("layout");
            this.deviceOrdinal = op.attributes().getAttrInt("device_ordinal");
        }
    }

    public static class Options {
        private Shape shape;
        private List<Long> layout;
        private Long deviceOrdinal;

        private Options() {
        }

        public Options shape(Shape shape) {
            this.shape = shape;
            return this;
        }

        public Options layout(List<Long> layout) {
            this.layout = layout;
            return this;
        }

        public Options layout(Long ... layout) {
            this.layout = Arrays.asList(layout);
            return this;
        }

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }
    }
}

