/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.risc;

import java.util.Arrays;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RiscCondition", inputsClass=Inputs.class)
public final class RiscCondition<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "RiscCondition";
    private Output<U> output;

    public RiscCondition(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TNumber, T extends TNumber> RiscCondition<U> create(Scope scope, Operand<TBool> pred, Operand<T> inputTrue, Operand<T> inputFalse, ConcreteFunction funcTrue, ConcreteFunction funcFalse, Class<U> DstT) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(pred.asOutput());
        opBuilder.addInput(inputTrue.asOutput());
        opBuilder.addInput(inputFalse.asOutput());
        opBuilder.setAttr("func_true", funcTrue);
        opBuilder.setAttr("func_false", funcFalse);
        opBuilder.setAttr("DstT", Operands.toDataType(DstT));
        return new RiscCondition<U>(opBuilder.build());
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RiscCondition.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<RiscCondition<?>> {
        public final Operand<TBool> pred;
        public final Operand<T> inputTrue;
        public final Operand<T> inputFalse;
        public final DataType SrcT;
        public final DataType DstT;

        public Inputs(GraphOperation op) {
            super(new RiscCondition(op), op, Arrays.asList("SrcT", "DstT"));
            int inputIndex = 0;
            this.pred = op.input(inputIndex++);
            this.inputTrue = op.input(inputIndex++);
            this.inputFalse = op.input(inputIndex++);
            this.SrcT = op.attributes().getAttrType("SrcT");
            this.DstT = op.attributes().getAttrType("DstT");
        }
    }
}

