/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.risc;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RiscConcat", inputsClass=Inputs.class)
public final class RiscConcat<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RiscConcat";
    private Output<T> output;

    public RiscConcat(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> RiscConcat<T> create(Scope scope, Iterable<Operand<T>> values, Operand<? extends TNumber> axis) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(values));
        opBuilder.addInput(axis.asOutput());
        return new RiscConcat<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RiscConcat.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<RiscConcat<T>> {
        public final Iterable<Operand<T>> values;
        public final Operand<? extends TNumber> axis;
        public final DataType T;
        public final DataType Tidx;

        public Inputs(GraphOperation op) {
            super(new RiscConcat(op), op, Arrays.asList("T", "Tidx"));
            int inputIndex = 0;
            int valuesLength = op.inputListLength("values");
            this.values = Arrays.asList((Operand[])op.inputList(inputIndex, valuesLength));
            inputIndex += valuesLength;
            this.axis = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tidx = op.attributes().getAttrType("Tidx");
        }
    }
}

