/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="Dilation2DBackpropInput", inputsClass=Inputs.class)
public final class Dilation2dBackpropInput<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Dilation2DBackpropInput";
    private Output<T> inBackprop;

    public Dilation2dBackpropInput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.inBackprop = operation.output(outputIdx++);
    }

    public static <T extends TNumber> Dilation2dBackpropInput<T> create(Scope scope, Operand<T> input, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, List<Long> rates, String padding) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Dilation2dBackpropInput");
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.addInput(outBackprop.asOutput());
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        long[] ratesArray = new long[rates.size()];
        for (int i = 0; i < ratesArray.length; ++i) {
            ratesArray[i] = rates.get(i);
        }
        opBuilder.setAttr("rates", ratesArray);
        opBuilder.setAttr("padding", padding);
        return new Dilation2dBackpropInput<T>(opBuilder.build());
    }

    public Output<T> inBackprop() {
        return this.inBackprop;
    }

    @Override
    public Output<T> asOutput() {
        return this.inBackprop;
    }

    @OpInputsMetadata(outputsClass=Dilation2dBackpropInput.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<Dilation2dBackpropInput<T>> {
        public final Operand<T> input;
        public final Operand<T> filter;
        public final Operand<T> outBackprop;
        public final DataType T;
        public final long[] strides;
        public final long[] rates;
        public final String padding;

        public Inputs(GraphOperation op) {
            super(new Dilation2dBackpropInput(op), op, Arrays.asList("T", "strides", "rates", "padding"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.filter = op.input(inputIndex++);
            this.outBackprop = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.strides = op.attributes().getAttrIntList("strides");
            this.rates = op.attributes().getAttrIntList("rates");
            this.padding = op.attributes().getAttrString("padding");
        }
    }
}

