/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ParseExampleV2", inputsClass=Inputs.class)
public final class ParseExample
extends RawOp {
    public static final String OP_NAME = "ParseExampleV2";
    private List<Output<TInt64>> sparseIndices;
    private List<Output<?>> sparseValues;
    private List<Output<TInt64>> sparseShapes;
    private List<Output<?>> denseValues;
    private List<Output<?>> raggedValues;
    private List<Output<?>> raggedRowSplits;

    public ParseExample(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int sparseIndicesLength = operation.outputListLength("sparse_indices");
        this.sparseIndices = Arrays.asList(operation.outputList(outputIdx, sparseIndicesLength));
        int sparseValuesLength = operation.outputListLength("sparse_values");
        this.sparseValues = Arrays.asList(operation.outputList(outputIdx += sparseIndicesLength, sparseValuesLength));
        int sparseShapesLength = operation.outputListLength("sparse_shapes");
        this.sparseShapes = Arrays.asList(operation.outputList(outputIdx += sparseValuesLength, sparseShapesLength));
        int denseValuesLength = operation.outputListLength("dense_values");
        this.denseValues = Arrays.asList(operation.outputList(outputIdx += sparseShapesLength, denseValuesLength));
        int raggedValuesLength = operation.outputListLength("ragged_values");
        this.raggedValues = Arrays.asList(operation.outputList(outputIdx += denseValuesLength, raggedValuesLength));
        int raggedRowSplitsLength = operation.outputListLength("ragged_row_splits");
        this.raggedRowSplits = Arrays.asList(operation.outputList(outputIdx += raggedValuesLength, raggedRowSplitsLength));
        outputIdx += raggedRowSplitsLength;
    }

    public static ParseExample create(Scope scope, Operand<TString> serialized, Operand<TString> names, Operand<TString> sparseKeys, Operand<TString> denseKeys, Operand<TString> raggedKeys, Iterable<Operand<?>> denseDefaults, Long numSparse, List<Class<? extends TType>> sparseTypes, List<Class<? extends TType>> raggedValueTypes, List<Class<? extends TNumber>> raggedSplitTypes, List<Shape> denseShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "ParseExample");
        opBuilder.addInput(serialized.asOutput());
        opBuilder.addInput(names.asOutput());
        opBuilder.addInput(sparseKeys.asOutput());
        opBuilder.addInput(denseKeys.asOutput());
        opBuilder.addInput(raggedKeys.asOutput());
        opBuilder.addInputList(Operands.asOutputs(denseDefaults));
        opBuilder.setAttr("num_sparse", numSparse);
        opBuilder.setAttr("sparse_types", Operands.toDataTypes(sparseTypes));
        opBuilder.setAttr("ragged_value_types", Operands.toDataTypes(raggedValueTypes));
        opBuilder.setAttr("ragged_split_types", Operands.toDataTypes(raggedSplitTypes));
        Shape[] denseShapesArray = new Shape[denseShapes.size()];
        for (int i = 0; i < denseShapesArray.length; ++i) {
            denseShapesArray[i] = denseShapes.get(i);
        }
        opBuilder.setAttr("dense_shapes", denseShapesArray);
        return new ParseExample(opBuilder.build());
    }

    public List<Output<TInt64>> sparseIndices() {
        return this.sparseIndices;
    }

    public List<Output<?>> sparseValues() {
        return this.sparseValues;
    }

    public List<Output<TInt64>> sparseShapes() {
        return this.sparseShapes;
    }

    public List<Output<?>> denseValues() {
        return this.denseValues;
    }

    public List<Output<?>> raggedValues() {
        return this.raggedValues;
    }

    public List<Output<?>> raggedRowSplits() {
        return this.raggedRowSplits;
    }

    @OpInputsMetadata(outputsClass=ParseExample.class)
    public static class Inputs
    extends RawOpInputs<ParseExample> {
        public final Operand<TString> serialized;
        public final Operand<TString> names;
        public final Operand<TString> sparseKeys;
        public final Operand<TString> denseKeys;
        public final Operand<TString> raggedKeys;
        public final Iterable<Operand<?>> denseDefaults;
        public final DataType[] Tdense;
        public final DataType[] sparseTypes;
        public final DataType[] raggedValueTypes;
        public final DataType[] raggedSplitTypes;
        public final Shape[] denseShapes;

        public Inputs(GraphOperation op) {
            super(new ParseExample(op), op, Arrays.asList("Tdense", "sparse_types", "ragged_value_types", "ragged_split_types", "dense_shapes"));
            int inputIndex = 0;
            this.serialized = op.input(inputIndex++);
            this.names = op.input(inputIndex++);
            this.sparseKeys = op.input(inputIndex++);
            this.denseKeys = op.input(inputIndex++);
            this.raggedKeys = op.input(inputIndex++);
            int denseDefaultsLength = op.inputListLength("dense_defaults");
            this.denseDefaults = Arrays.asList((Operand[])op.inputList(inputIndex, denseDefaultsLength));
            inputIndex += denseDefaultsLength;
            this.Tdense = op.attributes().getAttrTypeList("Tdense");
            this.sparseTypes = op.attributes().getAttrTypeList("sparse_types");
            this.raggedValueTypes = op.attributes().getAttrTypeList("ragged_value_types");
            this.raggedSplitTypes = op.attributes().getAttrTypeList("ragged_split_types");
            this.denseShapes = op.attributes().getAttrShapeList("dense_shapes");
        }
    }
}

