/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="BoostedTreesUpdateEnsemble", inputsClass=Inputs.class)
public final class BoostedTreesUpdateEnsemble
extends RawOp {
    public static final String OP_NAME = "BoostedTreesUpdateEnsemble";

    public BoostedTreesUpdateEnsemble(Operation operation) {
        super(operation, OP_NAME);
    }

    public static BoostedTreesUpdateEnsemble create(Scope scope, Operand<? extends TType> treeEnsembleHandle, Operand<TInt32> featureIds, Iterable<Operand<TInt32>> nodeIds, Iterable<Operand<TFloat32>> gains, Iterable<Operand<TInt32>> thresholds, Iterable<Operand<TFloat32>> leftNodeContribs, Iterable<Operand<TFloat32>> rightNodeContribs, Operand<TInt32> maxDepth, Operand<TFloat32> learningRate, Long pruningMode) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(treeEnsembleHandle.asOutput());
        opBuilder.addInput(featureIds.asOutput());
        opBuilder.addInputList(Operands.asOutputs(nodeIds));
        opBuilder.addInputList(Operands.asOutputs(gains));
        opBuilder.addInputList(Operands.asOutputs(thresholds));
        opBuilder.addInputList(Operands.asOutputs(leftNodeContribs));
        opBuilder.addInputList(Operands.asOutputs(rightNodeContribs));
        opBuilder.addInput(maxDepth.asOutput());
        opBuilder.addInput(learningRate.asOutput());
        opBuilder.setAttr("pruning_mode", pruningMode);
        return new BoostedTreesUpdateEnsemble(opBuilder.build());
    }

    @OpInputsMetadata(outputsClass=BoostedTreesUpdateEnsemble.class)
    public static class Inputs
    extends RawOpInputs<BoostedTreesUpdateEnsemble> {
        public final Operand<? extends TType> treeEnsembleHandle;
        public final Operand<TInt32> featureIds;
        public final Iterable<Operand<TInt32>> nodeIds;
        public final Iterable<Operand<TFloat32>> gains;
        public final Iterable<Operand<TInt32>> thresholds;
        public final Iterable<Operand<TFloat32>> leftNodeContribs;
        public final Iterable<Operand<TFloat32>> rightNodeContribs;
        public final Operand<TInt32> maxDepth;
        public final Operand<TFloat32> learningRate;
        public final long pruningMode;

        public Inputs(GraphOperation op) {
            super(new BoostedTreesUpdateEnsemble(op), op, Arrays.asList("pruning_mode"));
            int inputIndex = 0;
            this.treeEnsembleHandle = op.input(inputIndex++);
            this.featureIds = op.input(inputIndex++);
            int nodeIdsLength = op.inputListLength("node_ids");
            this.nodeIds = Arrays.asList((Operand[])op.inputList(inputIndex, nodeIdsLength));
            int gainsLength = op.inputListLength("gains");
            this.gains = Arrays.asList((Operand[])op.inputList(inputIndex += nodeIdsLength, gainsLength));
            int thresholdsLength = op.inputListLength("thresholds");
            this.thresholds = Arrays.asList((Operand[])op.inputList(inputIndex += gainsLength, thresholdsLength));
            int leftNodeContribsLength = op.inputListLength("left_node_contribs");
            this.leftNodeContribs = Arrays.asList((Operand[])op.inputList(inputIndex += thresholdsLength, leftNodeContribsLength));
            int rightNodeContribsLength = op.inputListLength("right_node_contribs");
            this.rightNodeContribs = Arrays.asList((Operand[])op.inputList(inputIndex += leftNodeContribsLength, rightNodeContribsLength));
            inputIndex += rightNodeContribsLength;
            this.maxDepth = op.input(inputIndex++);
            this.learningRate = op.input(inputIndex++);
            this.pruningMode = op.attributes().getAttrInt("pruning_mode");
        }
    }
}

