/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;

@OpMetadata(opType="BoostedTreesMakeQuantileSummaries", inputsClass=Inputs.class)
public final class BoostedTreesMakeQuantileSummaries
extends RawOp
implements Iterable<Operand<TFloat32>> {
    public static final String OP_NAME = "BoostedTreesMakeQuantileSummaries";
    private List<Output<TFloat32>> summaries;

    public BoostedTreesMakeQuantileSummaries(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int summariesLength = operation.outputListLength("summaries");
        this.summaries = Arrays.asList(operation.outputList(outputIdx, summariesLength));
        outputIdx += summariesLength;
    }

    public static BoostedTreesMakeQuantileSummaries create(Scope scope, Iterable<Operand<TFloat32>> floatValues, Operand<TFloat32> exampleWeights, Operand<TFloat32> epsilon) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(floatValues));
        opBuilder.addInput(exampleWeights.asOutput());
        opBuilder.addInput(epsilon.asOutput());
        return new BoostedTreesMakeQuantileSummaries(opBuilder.build());
    }

    public List<Output<TFloat32>> summaries() {
        return this.summaries;
    }

    @Override
    public Iterator<Operand<TFloat32>> iterator() {
        return this.summaries.iterator();
    }

    @OpInputsMetadata(outputsClass=BoostedTreesMakeQuantileSummaries.class)
    public static class Inputs
    extends RawOpInputs<BoostedTreesMakeQuantileSummaries> {
        public final Iterable<Operand<TFloat32>> floatValues;
        public final Operand<TFloat32> exampleWeights;
        public final Operand<TFloat32> epsilon;

        public Inputs(GraphOperation op) {
            super(new BoostedTreesMakeQuantileSummaries(op), op, Arrays.asList(new String[0]));
            int inputIndex = 0;
            int floatValuesLength = op.inputListLength("float_values");
            this.floatValues = Arrays.asList((Operand[])op.inputList(inputIndex, floatValuesLength));
            inputIndex += floatValuesLength;
            this.exampleWeights = op.input(inputIndex++);
            this.epsilon = op.input(inputIndex++);
        }
    }
}

