/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ReduceDataset", inputsClass=Inputs.class)
public final class ReduceDataset
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "ReduceDataset";
    private List<Output<?>> components;

    public ReduceDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int componentsLength = operation.outputListLength("components");
        this.components = Arrays.asList(operation.outputList(outputIdx, componentsLength));
        outputIdx += componentsLength;
    }

    public static ReduceDataset create(Scope scope, Operand<? extends TType> inputDataset, Iterable<Operand<?>> initialState, Iterable<Operand<?>> otherArguments, ConcreteFunction f, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInputList(Operands.asOutputs(initialState));
        opBuilder.addInputList(Operands.asOutputs(otherArguments));
        opBuilder.setAttr("f", f);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.useInterOpParallelism != null) {
                    opBuilder.setAttr("use_inter_op_parallelism", opts.useInterOpParallelism);
                }
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new ReduceDataset(opBuilder.build());
    }

    public static Options useInterOpParallelism(Boolean useInterOpParallelism) {
        return new Options().useInterOpParallelism(useInterOpParallelism);
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public List<Output<?>> components() {
        return this.components;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.components.iterator();
    }

    @OpInputsMetadata(outputsClass=ReduceDataset.class)
    public static class Inputs
    extends RawOpInputs<ReduceDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Iterable<Operand<?>> initialState;
        public final Iterable<Operand<?>> otherArguments;
        public final DataType[] Tstate;
        public final DataType[] Targuments;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final boolean useInterOpParallelism;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new ReduceDataset(op), op, Arrays.asList("Tstate", "Targuments", "output_types", "output_shapes", "use_inter_op_parallelism", "metadata"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            int initialStateLength = op.inputListLength("initial_state");
            this.initialState = Arrays.asList((Operand[])op.inputList(inputIndex, initialStateLength));
            int otherArgumentsLength = op.inputListLength("other_arguments");
            this.otherArguments = Arrays.asList((Operand[])op.inputList(inputIndex += initialStateLength, otherArgumentsLength));
            inputIndex += otherArgumentsLength;
            this.Tstate = op.attributes().getAttrTypeList("Tstate");
            this.Targuments = op.attributes().getAttrTypeList("Targuments");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.useInterOpParallelism = op.attributes().getAttrBool("use_inter_op_parallelism");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private Boolean useInterOpParallelism;
        private String metadata;

        private Options() {
        }

        public Options useInterOpParallelism(Boolean useInterOpParallelism) {
            this.useInterOpParallelism = useInterOpParallelism;
            return this;
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

