/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DataServiceDatasetV2", inputsClass=Inputs.class)
public final class DataServiceDatasetV2
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "DataServiceDatasetV2";
    private Output<? extends TType> handle;

    public DataServiceDatasetV2(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static DataServiceDatasetV2 create(Scope scope, Operand<TInt64> datasetId, Operand<TString> processingMode, Operand<TString> address, Operand<TString> protocol, Operand<TString> jobName, Operand<TInt64> consumerIndex, Operand<TInt64> numConsumers, Operand<TInt64> maxOutstandingRequests, Operand<? extends TType> iterationCounter, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(datasetId.asOutput());
        opBuilder.addInput(processingMode.asOutput());
        opBuilder.addInput(address.asOutput());
        opBuilder.addInput(protocol.asOutput());
        opBuilder.addInput(jobName.asOutput());
        opBuilder.addInput(consumerIndex.asOutput());
        opBuilder.addInput(numConsumers.asOutput());
        opBuilder.addInput(maxOutstandingRequests.asOutput());
        opBuilder.addInput(iterationCounter.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.taskRefreshIntervalHintMs != null) {
                    opBuilder.setAttr("task_refresh_interval_hint_ms", opts.taskRefreshIntervalHintMs);
                }
                if (opts.dataTransferProtocol != null) {
                    opBuilder.setAttr("data_transfer_protocol", opts.dataTransferProtocol);
                }
                if (opts.targetWorkers == null) continue;
                opBuilder.setAttr("target_workers", opts.targetWorkers);
            }
        }
        return new DataServiceDatasetV2(opBuilder.build());
    }

    public static Options taskRefreshIntervalHintMs(Long taskRefreshIntervalHintMs) {
        return new Options().taskRefreshIntervalHintMs(taskRefreshIntervalHintMs);
    }

    public static Options dataTransferProtocol(String dataTransferProtocol) {
        return new Options().dataTransferProtocol(dataTransferProtocol);
    }

    public static Options targetWorkers(String targetWorkers) {
        return new Options().targetWorkers(targetWorkers);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=DataServiceDatasetV2.class)
    public static class Inputs
    extends RawOpInputs<DataServiceDatasetV2> {
        public final Operand<TInt64> datasetId;
        public final Operand<TString> processingMode;
        public final Operand<TString> address;
        public final Operand<TString> protocol;
        public final Operand<TString> jobName;
        public final Operand<TInt64> consumerIndex;
        public final Operand<TInt64> numConsumers;
        public final Operand<TInt64> maxOutstandingRequests;
        public final Operand<? extends TType> iterationCounter;
        public final long taskRefreshIntervalHintMs;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final String dataTransferProtocol;
        public final String targetWorkers;

        public Inputs(GraphOperation op) {
            super(new DataServiceDatasetV2(op), op, Arrays.asList("task_refresh_interval_hint_ms", "output_types", "output_shapes", "data_transfer_protocol", "target_workers"));
            int inputIndex = 0;
            this.datasetId = op.input(inputIndex++);
            this.processingMode = op.input(inputIndex++);
            this.address = op.input(inputIndex++);
            this.protocol = op.input(inputIndex++);
            this.jobName = op.input(inputIndex++);
            this.consumerIndex = op.input(inputIndex++);
            this.numConsumers = op.input(inputIndex++);
            this.maxOutstandingRequests = op.input(inputIndex++);
            this.iterationCounter = op.input(inputIndex++);
            this.taskRefreshIntervalHintMs = op.attributes().getAttrInt("task_refresh_interval_hint_ms");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.dataTransferProtocol = op.attributes().getAttrString("data_transfer_protocol");
            this.targetWorkers = op.attributes().getAttrString("target_workers");
        }
    }

    public static class Options {
        private Long taskRefreshIntervalHintMs;
        private String dataTransferProtocol;
        private String targetWorkers;

        private Options() {
        }

        public Options taskRefreshIntervalHintMs(Long taskRefreshIntervalHintMs) {
            this.taskRefreshIntervalHintMs = taskRefreshIntervalHintMs;
            return this;
        }

        public Options dataTransferProtocol(String dataTransferProtocol) {
            this.dataTransferProtocol = dataTransferProtocol;
            return this;
        }

        public Options targetWorkers(String targetWorkers) {
            this.targetWorkers = targetWorkers;
            return this;
        }
    }
}

