/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorMapLookup", inputsClass=Inputs.class)
public final class TensorMapLookup<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "TensorMapLookup";
    private Output<U> value;

    public TensorMapLookup(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.value = operation.output(outputIdx++);
    }

    public static <U extends TType> TensorMapLookup<U> create(Scope scope, Operand<? extends TType> inputHandle, Operand<? extends TType> key, Class<U> valueDtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputHandle.asOutput());
        opBuilder.addInput(key.asOutput());
        opBuilder.setAttr("value_dtype", Operands.toDataType(valueDtype));
        return new TensorMapLookup<U>(opBuilder.build());
    }

    public Output<U> value() {
        return this.value;
    }

    @Override
    public Output<U> asOutput() {
        return this.value;
    }

    @OpInputsMetadata(outputsClass=TensorMapLookup.class)
    public static class Inputs
    extends RawOpInputs<TensorMapLookup<?>> {
        public final Operand<? extends TType> inputHandle;
        public final Operand<? extends TType> key;
        public final DataType keyDtype;
        public final DataType valueDtype;

        public Inputs(GraphOperation op) {
            super(new TensorMapLookup(op), op, Arrays.asList("key_dtype", "value_dtype"));
            int inputIndex = 0;
            this.inputHandle = op.input(inputIndex++);
            this.key = op.input(inputIndex++);
            this.keyDtype = op.attributes().getAttrType("key_dtype");
            this.valueDtype = op.attributes().getAttrType("value_dtype");
        }
    }
}

