/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;

@OpMetadata(opType="Stage", inputsClass=Inputs.class)
public final class Stage
extends RawOp {
    public static final String OP_NAME = "Stage";

    public Stage(Operation operation) {
        super(operation, OP_NAME);
    }

    public static Stage create(Scope scope, Iterable<Operand<?>> values, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(values));
        if (options != null) {
            for (Options opts : options) {
                if (opts.capacity != null) {
                    opBuilder.setAttr("capacity", opts.capacity);
                }
                if (opts.memoryLimit != null) {
                    opBuilder.setAttr("memory_limit", opts.memoryLimit);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new Stage(opBuilder.build());
    }

    public static Options capacity(Long capacity) {
        return new Options().capacity(capacity);
    }

    public static Options memoryLimit(Long memoryLimit) {
        return new Options().memoryLimit(memoryLimit);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    @OpInputsMetadata(outputsClass=Stage.class)
    public static class Inputs
    extends RawOpInputs<Stage> {
        public final Iterable<Operand<?>> values;
        public final long capacity;
        public final long memoryLimit;
        public final DataType[] dtypes;
        public final String container;
        public final String sharedName;

        public Inputs(GraphOperation op) {
            super(new Stage(op), op, Arrays.asList("capacity", "memory_limit", "dtypes", "container", "shared_name"));
            int inputIndex = 0;
            int valuesLength = op.inputListLength("values");
            this.values = Arrays.asList((Operand[])op.inputList(inputIndex, valuesLength));
            inputIndex += valuesLength;
            this.capacity = op.attributes().getAttrInt("capacity");
            this.memoryLimit = op.attributes().getAttrInt("memory_limit");
            this.dtypes = op.attributes().getAttrTypeList("dtypes");
            this.container = op.attributes().getAttrString("container");
            this.sharedName = op.attributes().getAttrString("shared_name");
        }
    }

    public static class Options {
        private Long capacity;
        private Long memoryLimit;
        private String container;
        private String sharedName;

        private Options() {
        }

        public Options capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Options memoryLimit(Long memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }
    }
}

