/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="OneHot", inputsClass=Inputs.class)
public final class OneHot<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "OneHot";
    private Output<U> output;

    public OneHot(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TType> OneHot<U> create(Scope scope, Operand<? extends TNumber> indices, Operand<TInt32> depth, Operand<U> onValue, Operand<U> offValue, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(depth.asOutput());
        opBuilder.addInput(onValue.asOutput());
        opBuilder.addInput(offValue.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.axis == null) continue;
                opBuilder.setAttr("axis", opts.axis);
            }
        }
        return new OneHot<U>(opBuilder.build());
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=OneHot.class)
    public static class Inputs<U extends TType>
    extends RawOpInputs<OneHot<U>> {
        public final Operand<? extends TNumber> indices;
        public final Operand<TInt32> depth;
        public final Operand<U> onValue;
        public final Operand<U> offValue;
        public final long axis;
        public final DataType T;
        public final DataType TI;

        public Inputs(GraphOperation op) {
            super(new OneHot(op), op, Arrays.asList("axis", "T", "TI"));
            int inputIndex = 0;
            this.indices = op.input(inputIndex++);
            this.depth = op.input(inputIndex++);
            this.onValue = op.input(inputIndex++);
            this.offValue = op.input(inputIndex++);
            this.axis = op.attributes().getAttrInt("axis");
            this.T = op.attributes().getAttrType("T");
            this.TI = op.attributes().getAttrType("TI");
        }
    }

    public static class Options {
        private Long axis;

        private Options() {
        }

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }
    }
}

