/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ImmutableConst", inputsClass=Inputs.class)
public final class ImmutableConst<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ImmutableConst";
    private Output<T> tensor;

    public ImmutableConst(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.tensor = operation.output(outputIdx++);
    }

    public static <T extends TType> ImmutableConst<T> create(Scope scope, Class<T> dtype, Shape shape, String memoryRegionName) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        opBuilder.setAttr("shape", shape);
        opBuilder.setAttr("memory_region_name", memoryRegionName);
        return new ImmutableConst<T>(opBuilder.build());
    }

    public Output<T> tensor() {
        return this.tensor;
    }

    @Override
    public Output<T> asOutput() {
        return this.tensor;
    }

    @OpInputsMetadata(outputsClass=ImmutableConst.class)
    public static class Inputs
    extends RawOpInputs<ImmutableConst<?>> {
        public final DataType dtype;
        public final Shape shape;
        public final String memoryRegionName;

        public Inputs(GraphOperation op) {
            super(new ImmutableConst(op), op, Arrays.asList("dtype", "shape", "memory_region_name"));
            boolean inputIndex = false;
            this.dtype = op.attributes().getAttrType("dtype");
            this.shape = op.attributes().getAttrShape("shape");
            this.memoryRegionName = op.attributes().getAttrString("memory_region_name");
        }
    }
}

