/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.buffer;

import org.tensorflow.ndarray.buffer.DataBufferWindow;
import org.tensorflow.ndarray.buffer.DataStorageVisitor;

public interface DataBuffer<T> {
    public long size();

    public boolean isReadOnly();

    public T getObject(long var1);

    public DataBuffer<T> setObject(T var1, long var2);

    default public DataBuffer<T> read(T[] dst) {
        return this.read(dst, 0, dst.length);
    }

    public DataBuffer<T> read(T[] var1, int var2, int var3);

    default public DataBuffer<T> write(T[] src) {
        return this.write(src, 0, src.length);
    }

    public DataBuffer<T> write(T[] var1, int var2, int var3);

    public DataBuffer<T> copyTo(DataBuffer<T> var1, long var2);

    default public DataBuffer<T> offset(long index) {
        return this.slice(index, this.size() - index);
    }

    default public DataBuffer<T> narrow(long size) {
        return this.slice(0L, size);
    }

    public DataBuffer<T> slice(long var1, long var3);

    default public DataBufferWindow<? extends DataBuffer<T>> window(long size) {
        throw new UnsupportedOperationException();
    }

    default public <R> R accept(DataStorageVisitor<R> visitor) {
        return visitor.fallback();
    }

    public boolean equals(Object var1);
}

