/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.c_api;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.PointerScope;
import org.bytedeco.javacpp.annotation.Properties;
import org.tensorflow.internal.c_api.TF_Buffer;
import org.tensorflow.internal.c_api.TF_Graph;
import org.tensorflow.internal.c_api.TF_Session;
import org.tensorflow.internal.c_api.TF_SessionOptions;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.presets.tensorflow;

@Properties(inherit={tensorflow.class})
public abstract class AbstractTF_Session
extends Pointer {
    protected TF_Graph graph;
    protected TF_SessionOptions opts;
    protected TF_Buffer run_options;
    protected TF_Buffer meta_graph_def;
    protected TF_Status status;

    public AbstractTF_Session(Pointer p) {
        super(p);
    }

    public static TF_Session newSession(TF_Graph graph, TF_SessionOptions opts, TF_Status status) {
        TF_Session s = org.tensorflow.internal.c_api.global.tensorflow.TF_NewSession(graph, opts, status);
        if (s != null) {
            s.graph = graph;
            s.opts = opts;
            s.status = status;
            s.deallocator(new DeleteDeallocator(s));
        }
        return s;
    }

    public static TF_Session loadSessionFromSavedModel(TF_SessionOptions session_options, TF_Buffer run_options, String export_dir, String[] tags, TF_Graph graph, TF_Buffer meta_graph_def, TF_Status status) {
        TF_Session s = org.tensorflow.internal.c_api.global.tensorflow.TF_LoadSessionFromSavedModel(session_options, run_options, new BytePointer(export_dir), new PointerPointer(tags), tags.length, graph, meta_graph_def, status);
        if (s != null) {
            s.graph = graph;
            s.opts = session_options;
            s.run_options = run_options;
            s.meta_graph_def = meta_graph_def;
            s.status = status;
            s.deallocator(new DeleteDeallocator(s));
        }
        return s;
    }

    public void delete() {
        this.deallocate();
    }

    protected static class DeleteDeallocator
    extends TF_Session
    implements Pointer.Deallocator {
        DeleteDeallocator(TF_Session s) {
            super(s);
        }

        public void deallocate() {
            if (!this.isNull()) {
                try (PointerScope scope = new PointerScope(new Class[0]);){
                    TF_Status status = TF_Status.newStatus();
                    org.tensorflow.internal.c_api.global.tensorflow.TF_CloseSession(this, status);
                    org.tensorflow.internal.c_api.global.tensorflow.TF_DeleteSession(this, status);
                    status.throwExceptionIfNotOK();
                    this.setNull();
                }
            }
        }
    }
}

