/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class SparseToDense<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "SparseToDense";
    private Output<U> dense;

    public static <U extends TType, T extends TNumber> SparseToDense<U> create(Scope scope, Operand<T> sparseIndices, Operand<T> outputShape, Operand<U> sparseValues, Operand<U> defaultValue, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(sparseIndices.asOutput());
        opBuilder.addInput(outputShape.asOutput());
        opBuilder.addInput(sparseValues.asOutput());
        opBuilder.addInput(defaultValue.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.validateIndices == null) continue;
                opBuilder.setAttr("validate_indices", opts.validateIndices);
            }
        }
        return new SparseToDense<U>(opBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public Output<U> dense() {
        return this.dense;
    }

    @Override
    public Output<U> asOutput() {
        return this.dense;
    }

    private SparseToDense(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.dense = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean validateIndices;

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }

        private Options() {
        }
    }
}

