/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.random;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

public final class Multinomial<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "Multinomial";
    private Output<U> output;

    public static <U extends TNumber> Multinomial<U> create(Scope scope, Operand<? extends TNumber> logits, Operand<TInt32> numSamples, Class<U> outputDtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(logits.asOutput());
        opBuilder.addInput(numSamples.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("output_dtype", Operands.toDataType(outputDtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new Multinomial<U>(opBuilder.build());
    }

    public static Multinomial<TInt64> create(Scope scope, Operand<? extends TNumber> logits, Operand<TInt32> numSamples, Options ... options) {
        return Multinomial.create(scope, logits, numSamples, TInt64.class, options);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    private Multinomial(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

