/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;

public final class FakeQuantWithMinMaxArgs
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "FakeQuantWithMinMaxArgs";
    private Output<TFloat32> outputs;

    public static FakeQuantWithMinMaxArgs create(Scope scope, Operand<TFloat32> inputs, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(inputs.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.min != null) {
                    opBuilder.setAttr("min", opts.min.floatValue());
                }
                if (opts.max != null) {
                    opBuilder.setAttr("max", opts.max.floatValue());
                }
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.narrowRange == null) continue;
                opBuilder.setAttr("narrow_range", opts.narrowRange);
            }
        }
        return new FakeQuantWithMinMaxArgs(opBuilder.build());
    }

    public static Options min(Float min) {
        return new Options().min(min);
    }

    public static Options max(Float max) {
        return new Options().max(max);
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public Output<TFloat32> outputs() {
        return this.outputs;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.outputs;
    }

    private FakeQuantWithMinMaxArgs(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputs = operation.output(outputIdx++);
    }

    public static class Options {
        private Float min;
        private Float max;
        private Long numBits;
        private Boolean narrowRange;

        public Options min(Float min) {
            this.min = min;
            return this;
        }

        public Options max(Float max) {
            this.max = max;
            return this;
        }

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        private Options() {
        }
    }
}

